% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure.R
\name{find_figure}
\alias{find_figure}
\title{Find a figure by name within an analysis.}
\usage{
find_figure(gf, analysis, name, description = NULL, create = FALSE)
}
\arguments{
\item{gf}{GoFigr client.}

\item{analysis}{Parent analysis object (or environment) in which to look
for the figure.}

\item{name}{Name of the figure to find.}

\item{description}{Optional description to use if a new figure must be
created.}

\item{create}{Logical; if `TRUE` and the figure doesn't exist, a new one
is created. If `FALSE`, an error is thrown when no matching figure is
found.}
}
\value{
A figure object corresponding to the matching (or newly created)
  figure.
}
\description{
Searches the figures attached to a given analysis by name and optionally
creates a new figure when no match is found. This is often the most
convenient way to obtain a figure handle in scripts and notebooks.
}
