% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph-documentation-with-examples.R
\name{gf_curve_interactive}
\alias{gf_curve_interactive}
\alias{gf_segment_interactive}
\title{Interactive curve plots}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain. Most users can safely ignore this argument.}

\item{gformula}{A formula with shape \code{y ~ x}. Faceting can be achieved by
including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer.}

\item{tooltip}{A formula specifying a variable for tooltips, or a character vector.}

\item{data_id}{A formula or character vector specifying data identifiers
for interactive selection.}

\item{...}{Additional arguments passed to the underlying geom.}

\item{alpha, color, size, shape, fill, group, stroke}{Aesthetics passed to the geom.}

\item{xlab, ylab, title, subtitle, caption}{Labels for the plot.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{show.help}{Logical. If \code{TRUE}, display some minimal help.}

\item{inherit}{Logical. If \code{TRUE}, inherit aesthetics from previous layers.}

\item{environment}{An environment in which to evaluate the formula.}
}
\value{
A gg object that can be displayed with \code{\link[=gf_girafe]{gf_girafe()}}.

A gg object that can be displayed with \code{\link[=gf_girafe]{gf_girafe()}}.
}
\description{
Creates an interactive plot using ggiraph. These functions extend
\code{\link[=gf_segment]{gf_segment()}} and  \code{\link[=gf_curve]{gf_curve()}} with interactive features like tooltips and
clickable elements.

Creates an interactive plot using ggiraph. This function extends
\code{\link[=gf_segment]{gf_segment()}} with interactive features like tooltips and clickable elements.
}
\section{Additional interactive features}{

\itemize{
\item \code{onclick}: JavaScript code (as character string) executed when clicking elements.
\item Additional ggiraph aesthetics may be available depending on the geom.
}


\itemize{
\item \code{onclick}: JavaScript code (as character string) executed when clicking elements.
\item Additional ggiraph aesthetics may be available depending on the geom.
}
}

\examples{
  gf_curve_interactive(
    1 + 2 ~ 0 + 4, color = "red", curvature = - 0.2,
    tooltip = ~ "curvature: -0.2",
    data_id = 0.2
  ) |>
  gf_curve_interactive(
    1 + 2 ~ 0 + 4, color = "blue", curvature = 0.4,
    tooltip = ~ "curvature: 0.4",
    data_id = 0.4) |>
  gf_segment_interactive(
    1 + 2 ~ 0 + 4, color = "green",
    tooltip = ~ "curvature: 0",
    data_id = 0
  ) |>
  gf_girafe(
    options = list(
      opts_hover(css = "stroke: black; stroke-width: 3;", nearest_distance = 10)
    )
  )

}
\seealso{
\code{\link[=gf_curve]{gf_curve()}}, \code{\link[=gf_girafe]{gf_girafe()}}

\code{\link[=gf_segment]{gf_segment()}}, \code{\link[=gf_girafe]{gf_girafe()}}
}
