% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheme-.R
\name{Scheme}
\alias{Scheme}
\title{Abstract Scheme Class}
\usage{
Scheme()
}
\description{
\code{scheme} is an abstract base class that represents a configurable scheme with
a unique \code{key} (the first class name). Developers should create subclasses of
\code{scheme} to define specific schemes used in layouts or plotting contexts.
}
\details{
Developers should subclass \code{Scheme} to implement specific behaviors (e.g.,
theme adjustments, alignment guides, layout spacings) and define how those
schemes are initialized, combined, and applied to plots.
}
\section{Developer Guide}{

When creating a new subclass of \code{Scheme}, you may optionally override the
following methods to customize its behavior:
\itemize{
\item \code{\link[=scheme_init]{scheme_init(scheme)}} \emph{(optional)}: Initializes the scheme,
often by assigning default values or computing derived properties.

\strong{Default behavior}: Returns the scheme unchanged.
\item \code{\link[=scheme_update]{scheme_update(e1, e2)}} \emph{(optional)}: Defines how to
update a scheme by merging it with another of the same key (e.g., during
user overrides).

\strong{Default behavior}: Replaces \code{e1} entirely with \code{e2}.
\item \code{\link[=scheme_inherit]{scheme_inherit(e1, e2)}} \emph{(optional)}: Defines how a
scheme inherits from a parent scheme (e.g., a layout template), typically
merging instead of replacing.

\strong{Default behavior}: Inheritance is ignored; \code{e2} is returned unchanged.
\item \code{\link[=plot_add_scheme]{plot_add_scheme(plot, scheme, ...)}}: Applies the scheme
to a plot object (usually a \code{ggplot}) by modifying the plot components,
theming, or annotations.
}
}

\keyword{internal}
