% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{Generate Data for Simulation}
\usage{
generate_data(
  nsub,
  nobs,
  p,
  beta0,
  rho,
  corstr = "AR1",
  dis = "normal",
  ka = 0,
  SNPs = NULL
)
}
\arguments{
\item{nsub}{Integer, the number of subjects.}

\item{nobs}{Integer or numeric vector, the number of observations per subject.}

\item{p}{Integer, the number of predictors.}

\item{beta0}{Numeric vector, initial coefficients for the first few predictors.}

\item{rho}{Numeric, the correlation coefficient used in generating correlated errors.}

\item{corstr}{Character, specifies the correlation of correlation structure for the covariance matrix.
Options are "cs" or "exchangeable" for compound symmetry, "AR1" for autoregressive, and any other input
will result in an identity matrix.}

\item{dis}{Character, the distribution of errors ("normal" or "t").}

\item{ka}{1 for heterogeneous errors and 0 for homogeneous errors.}

\item{SNPs}{User can provide simulated or real SNPs for genetic data simulation.}
}
\value{
A list containing two elements: `X`, the matrix of predictors, and `y`, the response vector.
}
\description{
This function generates simulated data including the predictor matrix `X` and the response vector `y`,
based on the specified parameters. The function allows for the simulation of data under different settings
of correlation, distribution, and the number of observations and subjects.
}
\examples{
set.seed(123)
sim_data <- generate_data(
  nsub = 50, nobs = rep(5, 50), p = 10,
  beta0 = c(rep(1, 5), rep(0, 5)), rho = 0.3
)
}
