% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_apply.R
\name{whiten_apply}
\alias{whiten_apply}
\title{Apply a whitening plan to design and data matrices}
\usage{
whiten_apply(
  plan,
  X,
  Y,
  runs = NULL,
  run_starts = NULL,
  censor = NULL,
  parcels = NULL,
  inplace = FALSE,
  parallel = TRUE
)
}
\arguments{
\item{plan}{Whitening plan from \code{\link[=fit_noise]{fit_noise()}}.}

\item{X}{Numeric matrix of predictors (time x regressors).}

\item{Y}{Numeric matrix of data (time x voxels).}

\item{runs}{Optional run labels.}

\item{run_starts}{Optional 0-based run start indices (alternative to \code{runs}).}

\item{censor}{Optional indices of censored TRs (1-based); filter resets after gaps.}

\item{parcels}{Optional parcel labels (length = ncol(Y)) when using parcel plans.}

\item{inplace}{Modify inputs in place (logical).}

\item{parallel}{Use OpenMP parallelism if available.}
}
\value{
List with whitened data. Parcel plans return \code{X_by} per parcel; others return a single \code{X} matrix.
}
\description{
Apply a whitening plan to design and data matrices
}
\examples{
# Create example design matrix and data
n_time <- 200
n_pred <- 3
n_voxels <- 50
X <- matrix(rnorm(n_time * n_pred), n_time, n_pred)
Y <- X \%*\% matrix(rnorm(n_pred * n_voxels), n_pred, n_voxels) +
     matrix(rnorm(n_time * n_voxels), n_time, n_voxels)

# Fit noise model from residuals
residuals <- Y - X \%*\% solve(crossprod(X), crossprod(X, Y))
plan <- fit_noise(residuals, method = "ar", p = 2)

# Apply whitening
whitened <- whiten_apply(plan, X, Y)
Xw <- whitened$X
Yw <- whitened$Y
}
