% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimum.reparam.R
\name{optimum.reparam}
\alias{optimum.reparam}
\title{Align two functions}
\usage{
optimum.reparam(
  Q1,
  T1,
  Q2,
  T2,
  lambda = 0,
  pen = "roughness",
  method = c("DP", "DPo", "SIMUL", "RBFGS"),
  f1o = 0,
  f2o = 0,
  nbhd_dim = 7
)
}
\arguments{
\item{Q1}{A numeric matrix of shape \verb{n_points x n_dimensions} specifying the
SRSF of the 1st \code{n_dimensions}-dimensional function evaluated on a grid of
size \code{n_points} of its univariate domain.}

\item{T1}{A numeric vector of size \code{n_points} specifying the grid on which
the 1st SRSF is evaluated.}

\item{Q2}{A numeric matrix of shape \verb{n_points x n_dimensions} specifying the
SRSF of the 2nd \code{n_dimensions}-dimensional function evaluated on a grid of
size \code{n_points} of its univariate domain.}

\item{T2}{A numeric vector of size \code{n_points} specifying the grid on which
the 1st SRSF is evaluated.}

\item{lambda}{A numeric value specifying the amount of warping. Defaults to
\code{0.0}.}

\item{pen}{alignment penalty (default="roughness") options are
second derivative ("roughness"), geodesic distance from id ("geodesic"), and
norm from id ("l2gam"), srvf norm from id ("l2psi")}

\item{method}{A string specifying the optimization method. Choices are
\code{"DP"}, \code{"DPo"}, \code{"SIMUL"}, or \code{"RBFGS"}. Defaults to \code{"DP"}.}

\item{f1o}{A numeric vector of size \code{n_dimensions} specifying the value of
the 1st function at \eqn{t = t_{\min}}. Defaults to \code{rep(0, n_dimensions)}.}

\item{f2o}{A numeric vector of size \code{n_dimensions} specifying the value of
the 2nd function at \eqn{t = t_{\min}}. Defaults to \code{rep(0, n_dimensions)}.}

\item{nbhd_dim}{size of the grid (default = 7)}
}
\value{
A numeric vector of size \code{n_points} storing discrete evaluations of
the estimated boundary-preserving warping diffeomorphism on the initial
grid.
}
\description{
This function aligns the SRVFs of two functions in \eqn{R^1} defined on an
interval \eqn{[t_{\min}, t_{\max}]} using dynamic programming or RBFGS
}
\examples{
q <- f_to_srvf(simu_data$f, simu_data$time)
gam <- optimum.reparam(q[, 1], simu_data$time, q[, 2], simu_data$time)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
May 2011. Registration of functional data using Fisher-Rao metric,
arXiv:1103.3817v2.

Tucker, J. D., Wu, W., Srivastava, A., Generative models for
functional data using phase and amplitude separation, Computational
Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
