% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equations.R
\name{num_solve}
\alias{num_solve}
\alias{sequation}
\alias{toLatex.equation_solve}
\title{Target Variable Value}
\usage{
num_solve(target, eqs, tol = 1e-06)

\method{toLatex}{equation_solve}(object, ...)

sequation(target, eqs, tol = 1e-06)
}
\arguments{
\item{target}{character: name of the variable value to compute}

\item{eqs}{an \code{equations} object}

\item{tol}{numeric: maximal tolerance for \code{\link[stats:uniroot]{stats::uniroot()}}}

\item{object}{object of a class for which a \code{toBibtex} or
    \code{toLatex} method exists.}

\item{...}{further arguments}
}
\value{
(for \code{num_solve}) Returns \code{numeric(0)}, \code{numeric(1)}, or a list of all (computed) values.

(For \code{toLatex.equation_solve}) A character vector.
}
\description{
Given a set of equations and some variables, \code{num_solve} tries to compute the value of the \code{target} variable.
The equations \eqn{y=f(x)} are transformed to \eqn{f(x)-y} and the functions try to compute the roots of the equations
using [\code{\link[stats:uniroot]{stats::uniroot()}}].
If the computation fails, then, \code{numeric(0)} is returned, otherwise the "original" value. If \code{target==''} then all computed values
and steps are returned. The attribute \code{compute} contains a data frame.

\code{toLatex.equation_solve} returns a LaTeX representation of the solution way found by \code{num_solve()}.
}
\examples{
# The equations describe the formulae for an confidence interval of the mean
e <- equations(o~x+c*s/sqrt(n), "v_o=\\\\bar{x}+c\\\\cdot\\\\frac{s^2}{n}", 
               u~x-c*s/sqrt(n), "v_u=\\\\bar{x}-c\\\\cdot\\\\frac{s^2}{n}", 
               e~c*s/sqrt(n),   "e  =c\\\\cdot\\\\frac{s^2}{\\\\sqrt{n}}",
               l~2*e,           "l  =2\\\\cdot e"                   
               )
e <- variables(e, 
               x=0,    "\\\\bar{x}",
               c=2.58, dbl(2), 
               s=1,    pos(5), "s^2",
               n=25,   pos(5),
               l=pos(5), 
               e=pos(5),
               u="v_u", o="v_o")
print(e)
# Find the confidence interval length
ns <- num_solve('l', e)
# Compute everything that is possible
 ns <- num_solve('', e)
toLatex(ns)

}
