% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.wrangling.r
\name{tally_wide}
\alias{tally_wide}
\title{Create contingency tables with two variables}
\usage{
tally_wide(tibble, rows, cols, wt = NULL, ...)
}
\arguments{
\item{tibble}{A tibble containing at least two columns}

\item{rows}{The column with the levels included as rows in the final table.}

\item{cols}{The column with the levels included as columns in the final table.}

\item{wt}{The column (numeric) whose values to add in order to fill the cells. If wt = NULL (the default), counts are returned instead of weighted sums.}

\item{...}{Any parameters that can be passed to tally_wide 'values_fill' is a useful one}
}
\value{
A tibble
}
\description{
This function takes a tibble and create human readable 
contingency tables from two variables, either by showing 
number of cases in each combination or weighted by the sum of a numerical variable
}
\examples{
 df <- tibble::tibble(
  group = c("A", "A", "B", "B", "B"),
    outcome = c("yes", "no", "yes", "yes", "no")
 )
tally_wide(df, rows = group, cols = outcome)
}
