% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_read_meta.R
\name{st_read_meta}
\alias{st_read_meta}
\title{read spatial metadata}
\usage{
st_read_meta(
  path,
  layer = 1L,
  tblname = tbl_name(path),
  conn = cached_connection(),
  ...
)
}
\arguments{
\item{path}{URL or path to spatial data file}

\item{layer}{layer number to read metadata for, defaults to first layer.}

\item{tblname}{metadata will be stored as a view with this name,
by default this is based on the name of the file.}

\item{conn}{A connection to a database.}

\item{...}{optional additional arguments passed to \code{\link[=duckdb_s3_config]{duckdb_s3_config()}}.
Note these apply after those set by the URI notation and thus may be used
to override or provide settings not supported in that format.}
}
\value{
A lazy \code{dplyr::tbl} object containing core spatial metadata such
as projection information.
}
\description{
At this time, reads a subset of spatial metadata.
This is similar to what is reported by \code{ogrinfo -json}
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
st_read_meta("https://github.com/duckdb/duckdb_spatial/raw/main/test/data/amsterdam_roads.fgb")
\dontshow{\}) # examplesIf}
}
