% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kurtosisDS2.R
\name{kurtosisDS2}
\alias{kurtosisDS2}
\title{Calculates the kurtosis of a numeric variable}
\usage{
kurtosisDS2(x, global.mean)
}
\arguments{
\item{x}{a string character, the name of a numeric variable.}

\item{global.mean}{a numeric, the combined mean of the input variable across all studies.}
}
\value{
a list including the sum of quartic differences between the values of x and the global mean of x across
all studies, the sum of squared differences between the values of x and the global mean of x across all studies,
the number of valid observations (i.e. the length of x after excluding missing values), and a validity message 
indicating indicating a valid analysis if the number of valid observations are above the protection filter 
nfilter.tab or invalid analysis otherwise.
}
\description{
This function calculates summary statistics that are returned to the client-side and 
used for the estimation of the combined kurtosis of a numeric variable across all studies.
}
\details{
The function calculates the sum of squared differences between the values of x and the global
mean of x across all studies, the sum of quatric differences between the values of x and the global mean
of x across all studies and the number of valid observations of the input variable x.
}
\author{
Demetris Avraam, for DataSHIELD Development Team
}
