% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_diseasystore.R
\name{test_diseasystore}
\alias{test_diseasystore}
\title{Test a given diseasy store}
\usage{
test_diseasystore(
  diseasystore_generator = NULL,
  conn_generator = NULL,
  data_files = NULL,
  target_schema = "test_ds",
  test_start_date = NULL,
  skip_backends = NULL,
  ...
)
}
\arguments{
\item{diseasystore_generator}{(\verb{Diseasystore*})\cr
The diseasystore R6 class generator to test.}

\item{conn_generator}{(\code{function})\cr
Function that generates a \code{list}() of connections use as target_conn.
Should take a \code{skip_backend} that does not open connections for the given backends.}

\item{data_files}{(\code{character()})\cr
List of files that should be available when testing.}

\item{target_schema}{(\code{character})\cr The schema to place the feature store in.  If the database backend does not support schema, the tables will be prefixed with \verb{<target_schema>.}.}

\item{test_start_date}{(\code{Date})\cr
The earliest date to retrieve data from during tests.}

\item{skip_backends}{(\code{character()})\cr
List of connection types to skip tests for due to missing functionality.}

\item{...}{Other parameters passed to the diseasystore generator.}
}
\value{
\code{NULL} (called for side effects)
}
\description{
This function runs a battery of tests of the given diseasystore.

The supplied diseasystore must be a generator for the diseasystore, not an instance of the diseasystore.

The tests assume that data has been made available locally to run the majority of the tests.
The location of the local data should be configured in the options for "source_conn" of the given
diseasystore before calling test_diseasystore.
}
\examples{
\dontshow{if (requireNamespace("duckdb", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
  # Generator for connections
  conns <- \(skip_backends) list(DBI::dbConnect(duckdb::duckdb()))

  # Call the testing suite
  test_diseasystore(
    diseasystore_generator = DiseasystoreSimulist,
    conn_generator = conns,
    target_schema = "test",
    test_start_date = as.Date("2020-02-20"),
    skip_backends = "SQLiteConnection"
  )
}
\dontshow{\}) # examplesIf}
}
