% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latent_cor.R
\name{latent_cor}
\alias{latent_cor}
\title{Latent correlations}
\usage{
latent_cor(
  dataSrc,
  item_property,
  predicate = NULL,
  nDraws = 500,
  hpd = 0.95,
  use = c("complete.obs", "pairwise.complete.obs")
)
}
\arguments{
\item{dataSrc}{A connection to a dexter database or a data.frame with columns: person_id, item_id, item_score and 
the item_property}

\item{item_property}{The name of the item property used to define the domains. If \code{dataSrc} is a dexter db then the
item_property must match a known item property. If dataSrc is a data.frame, item_property must be equal to
 one of its column names.}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{nDraws}{Number of draws for plausible values}

\item{hpd}{deprecated, use the `coef` method to set the highest posterior density interval.}

\item{use}{complete.obs uses only persons with answers on all domains. Pairwise.complete.obs uses all cases 
for which there are responses in at least two domains.}
}
\value{
`latent_cor` object, which is a list containing an estimated (mean) correlation matrix, the corresponding standard deviations, 
and the complete mcmc sample. Use the coef method to extract highest posterior density intervals around the estimated correlation matrix.
}
\description{
Estimates correlations between latent traits using plausible values as described in Marsman, et al. (2022). 
An item_property is used to distinguish the different scales.
}
\details{
To compute latent correlations, a model is estimated for each subscale. If a design for any subscale is not connected this will result in an error.  

Latent correlations are generated using a Bayesian approach. `Use` is `"pairwise.complete.obs"` works slightly different from 
`cor` since complete matrices are imputed. Therefore individual correlation matrices in the mcmc sample are positive semi-definite even with the pairwise option 
(assuming the matrix is not degenerate). However the mean of the mcmc sample need never be positive semidefinite.
}
\references{
Marsman, M., Bechger, T. M., & Maris, G. K. (2022). Composition algorithms for conditional distributions. 
In Essays on Contemporary Psychometrics (pp. 219-250). Cham: Springer International Publishing.
}
\seealso{
\code{\link{coef.latent_cor}}
}
