% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_ggower.R
\name{robust_ggower}
\alias{robust_ggower}
\title{Compute Robust Generalized Gower Distance}
\usage{
robust_ggower(data, w, p, robust_cov)
}
\arguments{
\item{data}{Numeric matrix or data frame with all variables combined.}

\item{w}{Numeric vector of weights for each observation. Will be normalized internally.}

\item{p}{Integer vector of length 3: \code{c(#cont, #binary, #categorical)}.}

\item{robust_cov}{Robust covariance matrix for continuous variables.}
}
\value{
A numeric matrix of squared robust Gower distances, normalized by geometric variability.
}
\description{
Computes a weighted, robust version of the Gower distance for mixed-type data
(continuous, binary, categorical). Continuous variables are handled via a
robust Mahalanobis distance using a supplied robust covariance matrix.
Binary and categorical variables are transformed into distances via similarity coefficients.
}
\details{
The function computes distances separately for continuous, binary, and categorical variables,
then scales each by its geometric variability and combines them. The output is a normalized
squared distance matrix suitable for robust clustering or aggregation procedures.

Continuous distances are Mahalanobis distances: \eqn{(x-y)^T (S)^-1 (x-y)}.
Categorical distances use a matching coefficient.
Binary distances are modified to account for positive/negative matches.
}
\keyword{internal}
