% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiSeries.R
\name{RequestCrossSeriesDetection}
\alias{RequestCrossSeriesDetection}
\title{Format a cross series with group by columns.}
\usage{
RequestCrossSeriesDetection(
  project,
  dateColumn,
  multiseriesIdColumns = NULL,
  crossSeriesGroupByColumns = NULL,
  maxWait = 600
)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{dateColumn}{character. The name of the column containing the date that defines the
time series.}

\item{multiseriesIdColumns}{character. Optional. The Series ID to demarcate the series. If
not specified, DataRobot will attempt to automatically infer the series ID.}

\item{crossSeriesGroupByColumns}{character. Optional. Column to split a cross series into
further groups. For example, if every series is sales of an individual product, the cross
series group could be e product category with values like "men's clothing", "sports
equipment", etc. Requires multiseries with \code{useCrossSeries} enabled.}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the model job to complete.}
}
\value{
A named list which contains:
\itemize{
  \item timeSeriesEligible logical. Whether or not the series is eligible to be used for
    time series.
  \item crossSeriesEligible logical. Whether or not the cross series group by column is
    eligible for cross-series modeling. Will be NULL if no cross series group by column
    is used.
  \item crossSeriesEligibilityReason character. The type of cross series eligibility
    (or ineligibility).
  \item timeUnit character. For time series eligible features, the time unit covered by a
    single time step, e.g. "HOUR", or NULL for features that are not time series eligible.
  \item timeStep integer. Expected difference in time units between rows in the data.
    Will be NULL for features that are not time series eligible.
}
}
\description{
Call this function to request the project be formatted as a cross series project with a
group by column.
}
\details{
Note that this function no longer needs to be called directly, but is called
indirectly as a part of \code{SetTarget} (which itself is called indirectly as part of
\code{StartProject}) when you pass a \code{crossSeriesGroupByColumn} using
\code{CreateDatetimePartitionSpecification}.
}
\seealso{
Other MultiSeriesProject functions: 
\code{\link{GetMultiSeriesProperties}()},
\code{\link{RequestMultiSeriesDetection}()},
\code{\link{as.dataRobotMultiSeriesProperties}()}
}
\concept{MultiSeriesProject functions}
