% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.smearplot.r
\name{gl.smearplot}
\alias{gl.smearplot}
\title{Smear plot}
\usage{
gl.smearplot(
  x,
  plot.display = TRUE,
  ind.labels = FALSE,
  label.size = 10,
  group.pop = FALSE,
  plot.theme = NULL,
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  het.only = FALSE,
  legend = "bottom",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{plot.display}{If TRUE, the plot is displayed in the plot window
[default TRUE].}

\item{ind.labels}{If TRUE, individual IDs are shown [default FALSE].}

\item{label.size}{Size of the individual labels [default 10].}

\item{group.pop}{If ind.labels is TRUE, group by population [default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default NULL].}

\item{plot.colors}{List of four color names for the column fill for homozygous reference,
heterozygous, homozygous alternate, and missing value (NA) [default c("#0000FF","#00FFFF","#FF0000","#e0e0e0")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]#'}

\item{het.only}{If TRUE, show only the heterozygous state [default FALSE]}

\item{legend}{Position of the legend: “left”, “top”, “right”, “bottom” or
'none' [default = 'bottom'].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity]}
}
\value{
Returns the ggplot object
}
\description{
Each locus is color coded for scores of 0, 1, 2 and NA for SNP data and 0, 1
and NA for presence/absence (SilicoDArT) data. Individual labels can be added.
Plot may become cluttered if ind.labels If there are too many individuals, 
it is best to use ind.labels = FALSE.

Works with both SNP data and P/A data (SilicoDArT)
}
\examples{
gl.smearplot(testset.gl,ind.labels=FALSE)
gl.smearplot(testset.gs,ind.labels=FALSE)
gl.smearplot(testset.gl[1:10,],ind.labels=TRUE)
gl.smearplot(testset.gs[1:10,],ind.labels=TRUE)
}
\seealso{
Other graphics: 
\code{\link{gl.colors}()},
\code{\link{gl.map.interactive}()},
\code{\link{gl.plot.heatmap}()},
\code{\link{gl.report.ld.map}()},
\code{\link{gl.select.colors}()},
\code{\link{gl.select.shapes}()},
\code{\link{gl.tree.nj}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{graphics}
