% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_outliers_gaussian.R
\name{outliers_gaussian}
\alias{outliers_gaussian}
\title{Outlier removal by Gaussian 3-sigma rule}
\usage{
outliers_gaussian(alpha = 3)
}
\arguments{
\item{alpha}{gaussian threshold (default 3)}
}
\value{
returns an outlier object
}
\description{
Removes outliers from numeric columns using the 3‑sigma rule under a Gaussian assumption:
values outside mean ± alpha·sd are flagged as outliers.
}
\examples{
# code for outlier removal
out_obj <- outliers_gaussian() # class for outlier analysis
out_obj <- fit(out_obj, iris) # computing boundaries
iris.clean <- transform(out_obj, iris) # returning cleaned dataset

#inspection of cleaned dataset
nrow(iris.clean)

idx <- attr(iris.clean, "idx")
table(idx)
iris.outliers_gaussian <- iris[idx,]
iris.outliers_gaussian
}
\references{
Pukelsheim, F. (1994). The Three Sigma Rule. The American Statistician 48(2):88–91.
}
