% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyl_cop_class.R
\name{plot,cyl_copula,missing-method}
\alias{plot,cyl_copula,missing-method}
\title{Plot '\code{cyl_copula}' Objects}
\usage{
\S4method{plot}{cyl_copula,missing}(x, n = 1000, ...)
}
\arguments{
\item{x}{\R object of class '\code{\linkS4class{cyl_copula}}'.}

\item{n}{sample size of the random sample drawn from \code{x}.}

\item{...}{additional arguments passed to \code{\link[base]{plot}()}.}
}
\value{
An invisible \code{NULL}. As side effect, a plot is produced.
}
\description{
Method for \code{\link[base]{plot}()} to draw a scatter plot of a
random sample from a circular-linear copula.
}
\examples{
set.seed(123)

plot(cyl_quadsec(0.1))
plot(cyl_vonmises(0,2), n = 100)
plot(cyl_quadsec(0.1),
   xlab = "something",
   ylab = "something else",
   main = "clever title",
   col = "red",
   fg = "blue",
   asp= 1)

}
