% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioactivity-APIs.R
\name{get_annotation_by_aeid}
\alias{get_annotation_by_aeid}
\title{Retrieve annotations for AEID}
\usage{
get_annotation_by_aeid(
  AEID = NULL,
  API_key = NULL,
  Server = bioactivity_api_server,
  verbose = FALSE
)
}
\arguments{
\item{AEID}{The assay endpoint identifier AEID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame containing the annotated assays corresponding to the
input AEID parameter
}
\description{
Retrieve annotations for AEID
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Retrieve annotation for an assay
annotation <- get_annotation_by_aeid(AEID = 159)
\dontshow{\}) # examplesIf}
}
