% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\encoding{UTF-8}
\name{get_pcor}
\alias{get_pcor}
\title{Extract a \code{coglasso} partial correlation matrix}
\usage{
get_pcor(sel_cg_obj, index_c = NULL, index_lw = NULL, index_lb = NULL)
}
\arguments{
\item{sel_cg_obj}{The object of \code{S3} class \code{select_coglasso} or of \code{S3}
class \code{coglasso}.}

\item{index_c}{The index of the \eqn{c} value different from the one
selected by model selection. To set only if the desired partial correlation
matrix is not the selected one.}

\item{index_lw}{The index of the \eqn{\lambda_w} value of the chosen
non-optimal partial correlation matrix. To set only if the desired partial
correlation matrix is not the selected one.}

\item{index_lb}{The index of the \eqn{\lambda_b} value of the chosen
non-optimal partial correlation matrix. To set only if the desired partial
correlation matrix is not the selected one.}
}
\value{
\code{get_pcor()} returns the selected partial correlation matrix.
}
\description{
\code{get_pcor()} extracts the selected partial correlation matrix from a
\code{select_coglasso} object, or a different specific one from either a
\code{select_coglasso} or a \code{coglasso} object when specifying the optional
parameters.
}
\details{
If the input is a \code{coglasso} object, it is necessary to specify all the
indexes to extract the chosen partial correlation matrix. \cr
If the input is a \code{select_coglasso} object, it extracts by default the
selected partial correlation matrix. If the selection method was "ebic", and
you want to extract a different partial correlation matrix than the selected
one, specify all indexes. Otherwise, if the objective is to extract the
optimal partial correlation matrix for a specific \eqn{c} value different
than the selected one, set \code{index_c} to your chosen one. Also here it is
possible to extract a specific non-optimal partial correlation matrix by
setting all the indexes to the chosen ones.
}
\examples{
\donttest{
sel_cg <- bs(multi_omics_sd_micro, p = c(4, 2), nlambda_w = 3, nlambda_b = 3,
                 nc = 3, verbose = FALSE)
sel_pcor <- get_pcor(sel_cg)
print(sel_pcor)
}

}
