% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridding.R
\name{par_make_dggrid}
\alias{par_make_dggrid}
\title{Convert DGGRID indices to sf object}
\usage{
par_make_dggrid(x, res = 8L, topology = "HEXAGON")
}
\arguments{
\item{x}{sf object.}

\item{res}{integer(1). DGGRID resolution. Default is 8L.}

\item{topology}{character(1). Topology type, either "HEXAGON" or "SQUARE".
Default is "HEXAGON".}
}
\value{
An \code{sf} object with polygons representing the DGGRID indices.
}
\description{
This function converts DGGRID indices to an \code{sf} object.
It requires the \code{dggridR} package to be installed.
}
\details{
\code{\link[dggridR:dgconstruct]{dggridR::dgconstruct}} is used to create a
DGGRID object with the specified resolution. All arguments in
this function are used as default values other than
\code{res} and \code{topology}.
}
\examples{
lastpar <- par(mfrow = c(1, 1))
library(sf)
if (rlang::is_installed("dggridR")) {
  library(dggridR)
  options(sf_use_s2 = FALSE)
  ncpath <- system.file("shape/nc.shp", package = "sf")
  nc <- read_sf(ncpath)
  nc <- st_transform(nc, "EPSG:4326")
  nc_comp_region_dggrid <-
    par_make_dggrid(
      nc,
      res = 8L,
      topology = "HEXAGON"
    )
  plot(sf::st_geometry(nc_comp_region_dggrid))
}
par(lastpar)
}
\seealso{
Other Parallelization: 
\code{\link{par_cut_coords}()},
\code{\link{par_grid}()},
\code{\link{par_grid_mirai}()},
\code{\link{par_hierarchy}()},
\code{\link{par_hierarchy_mirai}()},
\code{\link{par_make_grid}()},
\code{\link{par_make_h3}()},
\code{\link{par_merge_grid}()},
\code{\link{par_multirasters}()},
\code{\link{par_multirasters_mirai}()},
\code{\link{par_pad_balanced}()},
\code{\link{par_pad_grid}()},
\code{\link{par_split_list}()}
}
\author{
Insang Song
}
\concept{Parallelization}
