% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{get_code_label}
\alias{get_code_label}
\title{Retrieve Reference Codes and Labels}
\usage{
get_code_label(what = 4)
}
\arguments{
\item{what}{Integer indicating which reference table to return:
\itemize{
\item 1 = Census year and label
\item 2 = Sex code and label
\item 3 = Age (5-year group) code and label
\item 4 = Harmonized province code and label
\item 5 = Non-harmonized province code and label
}}
}
\value{
A data frame (or tibble) containing codes and labels for the
selected reference category.
}
\description{
This function returns reference tables for codes and labels used in the
package. It can provide mappings for census years, sex, age groups, and
province codes (harmonized or non-harmonized).
}
\details{
The function retrieves data from internal reference object
\code{re_label}, which stores standardized coding schemes and
their associated labels.
}
\examples{
# Get harmonized province codes and labels
get_code_label(4)

# Get sex codes and labels
get_code_label(2)

}
