% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_heatmap.R
\name{signature_heatmap}
\alias{signature_heatmap}
\title{Gene signature heatmap}
\usage{
signature_heatmap(
  x,
  type = c("subclass", "group", "groupsplit"),
  top = Inf,
  use_filter = NULL,
  arith_mean = FALSE,
  rank = c("max", "angle"),
  scale = c("none", "max", "sphere"),
  col = rev(hcl.colors(10, "Greens3")),
  text = TRUE,
  fontsize = 6.5,
  outlines = FALSE,
  outline_col = "black",
  subset = NULL,
  add_genes = NULL,
  ...
)
}
\arguments{
\item{x}{Either a gene signature matrix with genes in rows and cell
subclasses in columns, an object of S3 class 'cellMarkers' generated by
\code{\link[=cellMarkers]{cellMarkers()}}, or an object of class 'deconv' generated by
\code{\link[=deconvolute]{deconvolute()}}.}

\item{type}{Either "subclass" or "group" specifying whether to show the cell
subclass or cell group signature from a 'cellMarkers' or 'deconv' object.
"groupsplit" shows the distribution of mean gene expression for the group
signature across subclasses.}

\item{top}{Specifies the number of genes per subclass/group to be displayed.}

\item{use_filter}{Logical whether to show denoised gene signature.}

\item{arith_mean}{Logical whether to show log2(arithmetic mean), if
calculated, instead of usual mean(log2(counts +1)).}

\item{rank}{Either "max" or "angle" controlling whether genes (rows) are
ordered in the heatmap by max expression (the default) or lowest angle
(a measure of specificity of the gene as a cell marker).}

\item{scale}{Character value controlling scaling of genes: "none" for no scaling, "max" to equalise the maximum mean
expression between genes, "sphere" to scale genes to the unit hypersphere
where cell subclasses or groups are dimensions.}

\item{col}{Vector of colours passed to \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}.}

\item{text}{Logical whether to show values of the maximum cell in each row.}

\item{fontsize}{Numeric value for font size for cell values when
\code{text = TRUE}.}

\item{outlines}{Logical whether to outline boxes with maximum values in each
row. This supercedes \code{text}.}

\item{outline_col}{Colour for the outline boxes when \code{outlines = TRUE}.}

\item{subset}{Character vector of groups to be subsetted.}

\item{add_genes}{Character vector of gene names to be added to the heatmap.}

\item{...}{Optional arguments passed to \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}.}
}
\value{
A 'Heatmap' class object.
}
\description{
Produces a heatmap of genes signatures for each cell subclass using
ComplexHeatmap.
}
