% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartographr.R
\name{get_osmdata}
\alias{get_osmdata}
\title{Retrieve OpenStreetMap Data}
\usage{
get_osmdata(
  lat = NULL,
  lon = NULL,
  x_distance = NULL,
  y_distance = NULL,
  aspect_ratio = NULL,
  bbox = NULL,
  sf = NULL,
  quiet = TRUE,
  keep = TRUE
)
}
\arguments{
\item{lat}{Latitude of the center point (optional if bbox or sf is provided).}

\item{lon}{Longitude of the center point (optional if bbox or sf is provided).}

\item{x_distance}{Distance in the x-direction from the center point (optional).}

\item{y_distance}{Distance in the y-direction from the center point (optional).}

\item{aspect_ratio}{Aspect ratio of the x and y distances (optional).}

\item{bbox}{A bounding box to define the area of interest (optional if lat, lon, and distances are provided).}

\item{sf}{An sf object to define the area of interest (optional if bbox is provided).}

\item{quiet}{Logical flag to suppress progress messages.}

\item{keep}{Logical flag if additional OSM data should be kept.}
}
\value{
A list containing various elements of the OSM data, including street networks,
buildings, water bodies, green areas, beaches, parking areas, railways, and the
bounding box of the retrieved area.
}
\description{
This function retrieves OpenStreetMap (OSM) data based on geographic coordinates or a bounding box.
It allows for the specification of distances and aspect ratios to define the area of interest.
The function can return data in simple features (sf) format and has options to operate quietly.
}
\details{
The function performs checks to ensure the correct combination of parameters is provided.
It calculates the bounding box if not provided and retrieves various OSM features within the specified area.
}
\section{Exported Features}{

The following table lists the OSM features that are retrieved by the function:\tabular{ll}{
   Feature Type \tab OSM Tags \cr
   highway \tab motorway, motorway_link, trunk, trunk_link, primary, secondary, tertiary, \cr
    \tab unclassified, residential, living_street, street_lamp, pedestrian, track, path, steps \cr
   water \tab * \cr
   building \tab * \cr
   natural \tab beach, water, strait, bay, island, wood \cr
   amenity \tab parking \cr
   man_made \tab pier \cr
   railway \tab rail \cr
   place \tab sea, ocean \cr
   boundary \tab maritime \cr
   waterway \tab stream \cr
   landuse \tab forest, farmland, grass, orchard, allotments, recreation_ground, vineyard, cemetery, meadow \cr
   leisure \tab swimming_pool, pitch, nature_reserve, garden, park \cr
   natural \tab bay, island, wood \cr
}


Note: * all tags are retrieved
}

\examples{
\donttest{
osm_data <- get_osmdata(lat=44.568611, lon=15.331389, x_distance=100)
}
}
