% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-misc.R
\name{rand_names}
\alias{rand_names}
\alias{adjective_animal}
\alias{sample_letters}
\alias{resolve_ctor}
\alias{forward_ctor}
\alias{is_blockr_ctor}
\alias{ctor_name}
\alias{ctor_pkg}
\alias{ctor_fun}
\alias{to_sentence_case}
\alias{id_to_sentence_case}
\title{Random IDs}
\usage{
rand_names(
  old_names = character(0L),
  n = 1L,
  max_tries = 100L,
  id_fun = blockr_option("rand_id", NULL)
)

adjective_animal(n)

sample_letters(n)

resolve_ctor(ctor, ctor_pkg = NULL)

forward_ctor(x)

is_blockr_ctor(x)

ctor_name(x)

ctor_pkg(x)

ctor_fun(x)

to_sentence_case(x, replace = character(), with = character())

id_to_sentence_case(x)
}
\arguments{
\item{old_names}{Disallowed IDs}

\item{n}{Number of IDs to generate}

\item{max_tries}{Max number of attempts to create IDs that do not intersect
with \code{old_names}}

\item{id_fun}{A function with a single argument \code{n} that generates random
IDs. A value of \code{NULL} defaults to \code{\link[ids:adjective_animal]{ids::adjective_animal()}} if available and
\code{sample_letters} otherwise.}

\item{ctor}{Function (either a string, a function or number used to index
the call stack}

\item{ctor_pkg}{The package where \code{ctor} is defined (either a string or
\code{NULL} which will use the function environment)}

\item{x}{Character vector to transform}

\item{replace, with}{Mapped to \code{\link[base:grep]{base::gsub()}}}
}
\value{
A character vector of length \code{n} where each entry contains \code{length}
characters (all among \code{chars} and start/end with \code{prefix}/\code{suffix}), is
guaranteed to be unique and not present among values passed as \code{old_names}.
}
\description{
Randomly generated unique IDs are used throughout the package, created by
\code{rand_names()}. If random strings are required that may not clash with a set
of existing values, this can be guaranteed by passing them as \code{old_names}.
A \code{\link[=blockr_option]{blockr_option()}} \code{rand_id} can be set to swap out the function responsible
for ID generation.
}
\examples{
rand_names()
rand_names(n = 5L)
rand_names(id_fun = sample_letters)

}
