% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snb.R
\name{snb_data}
\alias{snb_data}
\title{Fetch Swiss National Bank (SNB) data}
\source{
\url{https://data.snb.ch/en}
}
\usage{
snb_data(key, start_date = NULL, end_date = NULL, lang = "en")
}
\arguments{
\item{key}{(\code{character(1)})\cr
The series key to query.}

\item{start_date}{(\code{NULL} | \code{character(1)} | \code{Date(1)})\cr
Start date of the data.}

\item{end_date}{(\code{NULL} | \code{character(1)} | \code{Date(1)})\cr
End date of the data.}

\item{lang}{(\code{character(1)})\cr
Language to query, either \code{"en"} or \code{"de"}. Default \code{"en"}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Retrieve time series data from the SNB data portal.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{
snb_data("rendopar")

# or filter for date range
snb_data("rendopar", "2020-01-01", "2020-12-31")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other data: 
\code{\link{bbk_data}()},
\code{\link{bbk_series}()},
\code{\link{bde_data}()},
\code{\link{bdf_codelist}()},
\code{\link{bdf_data}()},
\code{\link{bdf_dataset}()},
\code{\link{boc_data}()},
\code{\link{boe_data}()},
\code{\link{ecb_data}()},
\code{\link{onb_data}()}
}
\concept{data}
