% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-process.R
\name{post_process_pbf}
\alias{post_process_pbf}
\title{Post process pbf results}
\usage{
post_process_pbf(x, use_sf = TRUE)
}
\arguments{
\item{x}{an object as returned by \code{process_pbf()} or \code{read_pbf()}}

\item{use_sf}{default \code{TRUE}. Whether or not to return an \code{sf} object.}
}
\value{
An object of class \code{data.frame}, \code{sf}, or a scalar integer vector.

See \code{\link[=process_pbf]{process_pbf()}} for more details.
}
\description{
Applies post-processing to the results of \code{process_pbf()}
}
\details{
If \code{x} is a list object, the results will be row-binded. This is appropriate
if each element in the list is a \code{data.frame} or a feature result with
geometry. However, if each element is \emph{not} the same, the post-processing
\emph{will} error. If you cannot be certain that all elements that you will be
post processing will be the same, post-process each list element
independently.
}
\examples{
tbl_fp <- system.file("small-table.pbf", package = "arcpbf")
fc_fp <- system.file("small-points.pbf", package = "arcpbf")

# table feature collection
fc <- read_pbf(tbl_fp)
head(post_process_pbf(fc))

# feature collection with geometry
fc <- read_pbf(fc_fp)
head(post_process_pbf(fc))
}
