% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-add-delete.R, R/update-features.R
\name{add_features}
\alias{add_features}
\alias{delete_features}
\alias{update_features}
\title{Add Features to Feature Layer}
\usage{
add_features(
  x,
  .data,
  chunk_size = 500,
  match_on = c("name", "alias"),
  rollback_on_failure = TRUE,
  progress = TRUE,
  token = arc_token()
)

delete_features(
  x,
  object_ids = NULL,
  where = NULL,
  filter_geom = NULL,
  predicate = "intersects",
  rollback_on_failure = TRUE,
  chunk_size = 500,
  progress = TRUE,
  token = arc_token()
)

update_features(
  x,
  .data,
  chunk_size = 500,
  match_on = c("name", "alias"),
  rollback_on_failure = TRUE,
  progress = TRUE,
  token = arc_token()
)
}
\arguments{
\item{x}{an object of class \code{FeatureLayer}}

\item{.data}{an object of class \code{sf} or \code{data.frame}}

\item{chunk_size}{the maximum number of features to add at a time}

\item{match_on}{whether to match on the alias or the field name. Default,
the alias. See Details for more.}

\item{rollback_on_failure}{default \code{TRUE}. Specifies whether the edits should be
applied only if all submitted edits succeed.}

\item{progress}{default \code{TRUE}. A progress bar to be rendered by \code{httr2} to track requests.}

\item{token}{default \code{arc_token()}. An \code{httr2_token}.}

\item{object_ids}{a numeric vector of object IDs to be deleted.}

\item{where}{a simple SQL where statement indicating which features should be
deleted. When the where statement evaluates to \code{TRUE}, those values will be
deleted.}

\item{filter_geom}{an object of class \code{bbox}, \code{sfc} or \code{sfg} used to filter
query results based on a predicate function.}

\item{predicate}{Spatial predicate to use with \code{filter_geom}. Default
\code{"intersects"}. Possible options are \code{"intersects"}, \code{"contains"},
\code{"crosses"},  \code{"overlaps"},  \code{"touches"}, and \code{"within"}.}
}
\value{
\itemize{
\item \code{add_features()} returns a \code{data.frame} with columns \code{objectId}, \code{uniqueId}, \code{globalId}, \code{success}
\item \code{update_features()} returns a list with an element named \code{updateResults} which is a \code{data.frame} with columns \code{objectId}, \code{uniqueId}, \code{globalId}, \code{success}
\item \code{delete_features()} returns a list with an element named \code{deleteResults} which is a \code{data.frame} with columns \code{objectId}, \code{uniqueId}, \code{globalId}, \code{success}
}
}
\description{
Delete features from a feature layer based on object ID, a where clause, or a
spatial filter.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

For a more detailed guide to adding, updating, and deleting features, view the
tutorial on the \href{https://developers.arcgis.com/r-bridge/editing/overview/}{R-ArcGIS Bridge website}.

Regarding the \code{match_on} argument:when publishing an object to an ArcGIS Portal
from R, the object's names are provided as the alias. The object's names are
subject to change according to the standards of the ArcGIS REST API. For example.
\code{"Sepal.Length"} is changed to \code{"Sepal_Width"} in the \code{name} field but the alias
remains \code{"Sepal.Length"}. For that reason, we match on the alias name by default.
Change this argument to match based on the field name.
}
\examples{
\dontrun{
  # this is pseudo-code and will not work
  flayer <- arc_open(furl)

  # add sf objects to existing feature service
  add_features(flayer, sfobj)

  # delete all features
  delete_features(flayer, where = "1 = 1")

  # update features
  update_features(flayer, dfobj)
}
}
