% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formating.R
\name{column_spanner_label}
\alias{column_spanner_label}
\title{Prepend column spanner labels to data column labels}
\usage{
column_spanner_label(data, label, ..., relocate = TRUE)
}
\arguments{
\item{data}{data.frame or tibble}

\item{label}{character of column spanner}

\item{...}{columns (i.e., one or more tidyselect functions and/or a vector of quoted or unquoted variable names)}

\item{relocate}{relocate columns with same spanner label to be adjacent}
}
\value{
data.frame or tibble
}
\description{
Prepend column spanner labels to data column labels
}
\examples{
d <- data.frame(y = 1:3, x1 = 2:4, x2 = 3:5)

# Unquoted variable names
column_spanner_label(d, "Label", c(x1, x2))
# Character values (quoted variable names)
column_spanner_label(d, "Label", c("x1", "x2"))
# Tidyselect function (e.g., starts_with, ends_with, contains)
column_spanner_label(d, "Label", dplyr::starts_with("x"))
# Tidyselect range
column_spanner_label(d, "Label", x1:x2)
# Selected variables are relocated after the first selected variable
column_spanner_label(d, "Label", c(x2, y))
}
