% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AggregateGamesMethods.R
\docType{methods}
\name{MarginsAG-Methods}
\alias{MarginsAG-Methods}
\alias{calcMarginsAG}
\alias{calcPricesAG}
\alias{calcMarginsAG,ANY-method}
\alias{calcPricesAG,ANY-method}
\alias{calcMarginsAG,Logit-method}
\alias{calcMarginsAG,CES-method}
\alias{calcPricesAG,Logit-method}
\title{Methods for Calculating Prices and Margins Using Aggregative Games}
\usage{
\S4method{calcMarginsAG}{Logit}(object, preMerger = TRUE, level = FALSE)

\S4method{calcMarginsAG}{CES}(object, preMerger = TRUE, level = FALSE)

\S4method{calcPricesAG}{Logit}(object, preMerger = TRUE, isMax = FALSE, subset)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}

\item{preMerger}{If TRUE, returns pre-merger outcome. If
FALSE, returns post-merger outcome.  Default is TRUE.}

\item{level}{IF TRUE, return margins in dollars. If FALSE, returns 
margins in proportions. Default for most classes is FALSE.}

\item{isMax}{If TRUE, a check is run to determine if the calculated equilibrium price vector locally maximizes profits.
Default is FALSE.}

\item{subset}{A vector whose length equals the number  of products where each element equals TRUE if
the product indexed by that element should be included in the
post-merger simulation and FALSE if it should be excluded. Default is a
length k vector of TRUE.}
}
\description{
Computes equilibrium product margins and prices using the aggregative games technique described in
Nocke and Schutz (2018). Assumes that firms are playing a
Nash-Bertrand pricing game with either Logit or CES demand
}
\references{
Nocke, V. and Schutz, N. (2018), Multiproduct-Firm Oligopoly: An Aggregative Games Approach. Econometrica, 86: 523-557.\doi{10.3982/ECTA14720}/
}
\keyword{methods}
