% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temis_download.R
\name{temis_uvdvc}
\alias{temis_uvdvc}
\alias{temis_uvdec}
\alias{temis_clim}
\title{Download TEMIS file}
\usage{
temis_uvdvc(years, path, climatology = TRUE, region = "europe")

temis_uvdec(years, path, climatology = TRUE, region = "europe")

temis_clim(path, uv_type, region = "europe")
}
\arguments{
\item{years}{The range of years for which UV files will be downloaded, either an integer range or a date vector such as a date column in a dataframe. The data file for an additional year to the provided range is downloaded for non-daily UV dose calculations to account for earlier dates. For example, for the CW-D-UVB dose in \link{cw_uvb} a sample dated 01-02-2007 requires UV data up to 18-09-2006.}

\item{path}{Directory where files will be downloaded to ("path/to/dir").}

\item{climatology}{If TRUE (default) the climatology file will be downloaded. If FALSE, only year files will be downloaded. The same climatology file is used regardless of the specified year range.}

\item{region}{As illustrated in the maps below, if "europe" (default), files covering Europe region will be downloaded, if "world", world files will be downloaded.
\if{html}{\figure{March2025_vitD_cloudy_europe.png}{options: style="width:500px;max-width:50\%;"}}
\if{latex}{\figure{March2025_vitD_cloudy_europe.png}{}}
\if{html}{\figure{March2025_vitD_cloudy_world.png}{options: style="width:500px;max-width:50\%;"}}
\if{latex}{\figure{March2025_vitD_cloudy_world.png}{}}}

\item{uv_type}{For temis_clim, "uve" or "uvb" for erythemal UV or vitamin D UVB, respectively.}
}
\value{
Files downloaded to specified directory.
}
\description{
These functions download UV files from TEMIS for a given range of years present. \code{temis_uvdvc} returns vitamin D UV data and \code{temis_uvdec} returns erythemal UV data. \code{temis_clim} returns only a climatology file.
For various technical reasons, some days are missing UV observations. TEMIS provides a climatology file, which is a UV file with values averaged across 2004-2020 and is used in the other functions to fill in these missing observations.
In the first two functions, the climatology file is downloaded by default and used downstream to fill in missing observations. It contains UV (erythemal or UVB) values for each day averaged over 17 years: 2004 - 2020 (leap day 29 Feb. is skipped).
Yearly UV files are downloaded from TEMIS for Europe by default.
The UV doses, in kJ/m2, are calculated based on cloud-adjusted data. See maps below for area coverage for each of the "europe" and "world" regions (as of 21 March 2025).
See \url{https://www.temis.nl/uvradiation/product/uvncinfo.html} for more info. Cloud-adjusted TEMIS data is available from 19-Jan-2004 onwards.
}
