% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probitInverse.R
\name{probitInverse}
\alias{probitInverse}
\title{Probit-Inverse of Group-Level Normal Distribution}
\usage{
probitInverse(mu, sigma, fittedModel = NULL)
}
\arguments{
\item{mu}{latent-probit mean of normal distribution}

\item{sigma}{latent-probit SD of normal distribution}

\item{fittedModel}{optional: fitted \link{traitMPT} model. If provided, the
bivariate inverse-probit transform is applied to all MCMC samples (and
\code{mu} and \code{sigma} are ignored).}
}
\value{
implied mean and SD on probability scale
}
\description{
Transform latent group-level normal distribution (latent-trait MPT) into mean
and SD on probability scale.
}
\examples{
####### compare bivariate vs. univariate transformation
probitInverse(mu = 0.8, sigma = c(0.25, 0.5, 0.75, 1))
pnorm(0.8)

# full distribution
prob <- pnorm(rnorm(10000, mean = 0.8, sd = 0.7))
hist(prob, 80, col = "gray", xlim = 0:1)

\dontrun{
# transformation for fitted model
mean_sd <- probitInverse(fittedModel = fit)
summarizeMCMC(mean_sd)
}
}
