% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OI_utils.R
\name{estimate_OIcov}
\alias{estimate_OIcov}
\title{Estimate parameters of orthogonally invariant covariance}
\usage{
estimate_OIcov(x, Mhat, tau = NULL)
}
\arguments{
\item{x}{A single sample of symmetric matrices. \code{x} must be either an \code{\link{fsm}} object or something that \code{\link[=as_fsm]{as_fsm()}} can parse.}

\item{Mhat}{A maximum-likelihood estimate of the population mean}

\item{tau}{The parameter \eqn{\tau}{tau}. If supplied only \eqn{\sigma^2}{s^2} will be estimated.}
}
\value{
A named list of \eqn{\sigma^2}{s^2} and \eqn{\tau}
}
\description{
Orthogonally-invariant covariance is a restrictive structure, but if it holds then a suite of tools is available \insertCite{schwartzman2008in}{TFORGE}.
Any orthogonally-invariant covariance can be specified by just two parameters \eqn{\tau}{tau} and \eqn{\sigma^2}{s^2}.
For Gaussian-distributed elements, this function estimates the parameters \eqn{\tau}{tau} and \eqn{\sigma^2}{s^2} by maximum-likelihood from the data and using a maximum-likelihood estimate of the population mean \insertCite{@Lemma 3.3, @schwartzman2008in}{TFORGE}.
}
\section{Orthogonally-Invariant Covariance}{
A symmetric random matrix \eqn{Y} with a Gaussian distribution has orthogonally-invariant covariance if and only if \eqn{Q Y Q^T} has the same distribution as \eqn{Y} for any orthogonal matrix \eqn{Q}.

Using the parameterisation of \eqn{\tau}{tau} and \eqn{\sigma^2}{s^2} by \insertCite{schwartzman2008in;textual}{TFORGE}:
\itemize{
\item the covariance of the off-diagonal elements of \eqn{Y} is \eqn{I\sigma^2/2}{Is^2/2} where \eqn{I} is the identity matrix of the correct size.
\item the covariance of the diagonal elements of \eqn{Y} is \eqn{\sigma^2 (I + 1 1^T \tau/(1-\tau p) )}{s^2 (I + 1 1^T \tau/(1-\tau p) )} where \eqn{p} is the number of columns of \eqn{Y} and \eqn{1} is the vector of ones.
\item the covariance between diagonal elements and non-diagonal elements is zero (i.e. they are independent).
}
}

\references{
\insertAllCited{}
}
