% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_progression.R
\name{assumptions_progression}
\alias{assumptions_progression}
\alias{generate_progression}
\alias{true_summary_statistics_progression}
\alias{progression_rate_from_progression_prop}
\alias{cen_rate_from_cen_prop_progression}
\alias{hazard_before_progression_from_PH_effect_size}
\title{Create an empty assumtions data.frame for generate_progression}
\usage{
assumptions_progression(print = interactive())

generate_progression(condition, fixed_objects = NULL)

true_summary_statistics_progression(
  Design,
  what = "os",
  cutoff_stats = NULL,
  fixed_objects = NULL,
  milestones = NULL
)

progression_rate_from_progression_prop(design)

cen_rate_from_cen_prop_progression(design)

hazard_before_progression_from_PH_effect_size(
  design,
  target_power_ph = NA_real_,
  final_events = NA_real_,
  target_alpha = 0.025
)
}
\arguments{
\item{print}{print code to generate parameter set?}

\item{condition}{condition row of Design dataset}

\item{fixed_objects}{additional settings, see details}

\item{Design}{Design data.frame for subgroup}

\item{what}{True summary statistics for which estimand}

\item{cutoff_stats}{(optionally named) cutoff time, see details}

\item{milestones}{(optionally named) vector of times at which milestone survival should be calculated}

\item{design}{design data.frame}

\item{target_power_ph}{target power under proportional hazards}

\item{final_events}{target events for inversion of Schönfeld Formula, defaults to \code{condition$final_events}}

\item{target_alpha}{target one-sided alpha level for the power calculation}
}
\value{
For generate_progression: a design tibble with default values invisibly

For generate_progression: A dataset with the columns t (time) and trt
(1=treatment, 0=control), evt (event, currently TRUE for all observations),
t_ice (time of intercurrent event), ice (intercurrent event)

For true_summary_statistics_subgroup: the design data.frame
passed as argument with the additional columns

For progression_rate_from_progression_prop: the design data.frame passed as
argument with the additional columns prog_rate_trt, prog_rate_ctrl

for cen_rate_from_cen_prop_progression: design data.frame with the
additional column random_withdrawal

For hazard_before_progression_from_PH_effect_size: the design
data.frame passed as argument with the additional column hazard_trt.
}
\description{
Create an empty assumtions data.frame for generate_progression

Generate Dataset with changing hazards after disease progression

Calculate progression rate from proportion of patients who progress

Calculate hr after onset of treatment effect
}
\details{
assumptions_progression generates a default design \code{data.frame} for
use with generate_progression If print is \code{TRUE} code to produce the
template is also printed for copying, pasting and editing by the user.
(This is the default when run in an interactive session.)

Condidtion has to contain the following columns:
\itemize{
\item n_trt number of paitents in treatment arm
\item n_ctrl number of patients in control arm
\item hazard_ctrl hazard in the control arm
\item hazard_trt hazard in the treatment arm for not cured patients
\item hazard_after_prog hazard after disease progression
\item prog_rate_ctrl hazard rate for disease progression unter control
\item prog_rate_trt hazard rate for disease progression unter treatment
}

\code{what} can be \code{"os"} for overall survival and \code{"pfs"} for progression free
survival.

The if \code{fixed_objects} contains \code{t_max} then this value is used as the
maximum time to calculate function like survival, hazard, ... of the data
generating models. If this is not given \code{t_max} is choosen as the minimum of
the \code{1-(1/10000)} quantile of all survival distributions in the model.

\code{cutoff_stats} are the times used to calculate the statistics like average
hazard ratios and RMST, that are only calculated up to a certain point.

For progression_rate_from_progression_prop, the design data.frame,
has to contain the columns \code{prog_prop_trt} and \code{prog_prop_ctrl} with the
proportions of patients, who progress in the respective arms.

cen_rate_from_cen_prop_progression takes the proportion of
censored patients from the column \code{censoring_prop}. This column describes
the proportion of patients who are censored randomly before experiencing an
event, without regard to administrative censoring.

\code{hazard_before_progression_from_PH_effect_size} calculates the
hazard ratio after onset of treatment effect as follows: First calculate
the hazard in the control arm that would give the same median survival
under an exponential model. Then calculate the median survival in the
treatment arm that would give the desired power of the logrank test under
exponential models in control and treatment arm. Then callibrate the hazard
before progression in the treatment arm to give the same median survival
time.

This is a heuristic and to some extent arbitrary approach to calculate
hazard ratios that correspond to reasonable and realistic scenarios.
}
\section{Functions}{
\itemize{
\item \code{assumptions_progression()}: generate default assumptions \code{data.frame}

\item \code{generate_progression()}: simulates a dataset with changing hazards after disease progression

\item \code{true_summary_statistics_progression()}: calculate true summary statistics for scenarios with disease progression

\item \code{progression_rate_from_progression_prop()}: Calculate progression rate from proportion of patients who progress

\item \code{cen_rate_from_cen_prop_progression()}: calculate censoring rate from censoring proportion

\item \code{hazard_before_progression_from_PH_effect_size()}: Calculate hazard in the treatment arm before progression from PH effect size

}}
\examples{
Design <- assumptions_progression()
Design
one_simulation <- merge(
    assumptions_progression(),
    design_fixed_followup(),
    by=NULL
  ) |>
  tail(1) |>
  generate_progression()
head(one_simulation)
tail(one_simulation)

my_design <- merge(
  assumptions_progression(),
  design_fixed_followup(),
  by=NULL
)

my_design_os  <- true_summary_statistics_progression(my_design, "os")
my_design_pfs <- true_summary_statistics_progression(my_design, "pfs")
my_design_os
my_design_pfs
my_design <- merge(
    assumptions_progression(),
    design_fixed_followup(),
    by=NULL
  )
my_design$prog_rate_ctrl <- NA_real_
my_design$prog_rate_trt <- NA_real_
my_design$prog_prop_trt <- 0.2
my_design$prog_prop_ctrl <- 0.3
my_design <- progression_rate_from_progression_prop(my_design)
my_design
design <- expand.grid(
hazard_ctrl         = m2r(15),          # hazard under control
hazard_trt          = m2r(18),          # hazard under treatment
hazard_after_prog   = m2r(3),           # hazard after progression
prog_rate_ctrl      = m2r(12),          # hazard for disease progression under control
prog_rate_trt       = m2r(c(12,16,18)), # hazard for disease progression under treatment
censoring_prop      = 0.1,              # rate of random withdrawal
followup            = 100,              # follow up time
n_trt               = 50,               # patients in treatment arm
n_ctrl              = 50                # patients in control arm
)
cen_rate_from_cen_prop_progression(design)
\donttest{
my_design <- merge(
  design_fixed_followup(),
  assumptions_progression(),
  by=NULL
)

my_design$hazard_trt <- NULL
my_design$final_events <- ceiling(0.75 * (my_design$n_trt + my_design$n_ctrl))

my_design <- hazard_before_progression_from_PH_effect_size(my_design, target_power_ph=0.7)
my_design
}
}
