% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoboost.R
\name{auto.analyze}
\alias{auto.analyze}
\alias{auto.analyze.selectboost}
\title{Find limits for selectboost analysis}
\usage{
auto.analyze(x, ...)

\method{auto.analyze}{selectboost}(x, ...)
}
\arguments{
\item{x}{Numerical matrix. Selectboost object.}

\item{...}{. Passed to the summary.selectboost function.}
}
\value{
list of results.
}
\description{
Find limits for selectboost analysis.
}
\details{
\code{plot.summary.selectboost} returns an invisible list and creates four graphics.
Two plots the proportion of selection with respect to c0 (by step or according to real scale).
On the third graph, no bar means a proportion of selection less than prop.level.
Confidence intervals are computed at the conf.int.level level.
Barplot of the confidence index (1-min(c0, such that proportion|c0>conf.threshold)).
}
\examples{
data(autoboost.res.x)
auto.analyze(autoboost.res.x)

data(autoboost.res.x2)
auto.analyze(autoboost.res.x2)

}
\references{
\emph{selectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets}, Frédéric Bertrand, Ismaïl Aouadi, Nicolas Jung, Raphael Carapito, Laurent Vallat, Seiamak Bahram, Myriam Maumy-Bertrand, Bioinformatics, 2020. \doi{10.1093/bioinformatics/btaa855}
}
\seealso{
\code{\link{fastboost}} and \code{\link{autoboost}}

Other Selectboost analyze functions: 
\code{\link{plot.summary.selectboost}()},
\code{\link{trajC0}()}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@lecnam.net}
}
\concept{Selectboost analyze functions}
