% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{fuzzycoco}
\alias{fuzzycoco}
\title{creates a model for the Fuzzy Coco algorithm}
\usage{
fuzzycoco(
  mode = c("classification", "regression"),
  params,
  seed = sample.int(10^5, 1),
  verbose = FALSE
)
}
\arguments{
\item{mode}{the type of model, either \strong{classification} or \strong{regression}}

\item{params}{fuzzy coco parameters, as a recursive named list, cf \code{\link[=params]{params()}}}

\item{seed}{the RNG seed to use (to fit the model)}

\item{verbose}{whether to be verbose}
}
\value{
a \emph{fuzzycoco_model} object (named list)
}
\description{
creates a model for the Fuzzy Coco algorithm
}
\examples{
model <- fuzzycoco("regression", params(nb_rules = 1, nb_max_var_per_rule = 3), seed = 123)
}
