% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Empirical_MP.R
\name{doRec}
\alias{doRec}
\title{Calculate a management recommendation given constraints}
\usage{
doRec(MPrec, mod, delta_down, delta_up, TACrng)
}
\arguments{
\item{MPrec}{Positive real number, the previous management recommendation (e.g. 100 tonnes).}

\item{mod}{Imperfect fraction, the proposed modification (change to MPrec) (e.g. 1.2 is a 20\% increase)}

\item{delta_down}{A vector 2 positions long, the minimum and maximum levels of downward change (e.g. when mod < 1) in the recommendation.}

\item{delta_up}{A vector 2 positions long, the minimum and maximum levels of upward change (e.g. when mod > 1) in the recommendation.}

\item{TACrng}{A vector 2 positions long, the minimum and maximum TAC (same units as MPrec).}
}
\value{
n object of class \linkS4class{Rec}.
}
\description{
Creates a TAC management recommendation given constraints on how much that can change from previous TAC and contraints on minimum and maximum TAC
}
\author{
T. Carruthers
}
