% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equilibrium-lifecycle.R
\name{equilibrium_lifeycle}
\alias{equilibrium_lifeycle}
\title{Calculate Equilibrium for Lifecycle Model (Logistic or Lotka-Volterra)}
\usage{
equilibrium_lifeycle(
  params,
  NF,
  phi = 0.5,
  log_dd = TRUE,
  spn_P,
  pop_ratio_Aq = NULL,
  pop_ratio_F = NULL,
  pop_ratio_M = NULL,
  cube
)
}
\arguments{
\item{params}{a named list of parameters (see details)}

\item{NF}{vector of female mosquitoes at equilibrium, for every population in the environment}

\item{phi}{sex ratio of mosquitoes at emergence}

\item{log_dd}{Boolean: TRUE implies logistic density dependence, FALSE implies Lotka-Volterra model}

\item{spn_P}{the set of places (P) (see details)}

\item{pop_ratio_Aq}{May be empty; if not, a named vector or matrix. (see details)}

\item{pop_ratio_F}{May be empty; if not, a named vector or matrix. (see details)}

\item{pop_ratio_M}{May be empty; if not, a named vector or matrix. (see details)}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}
}
\value{
a list with 3 elements: \code{init} a matrix of equilibrium values for every life-cycle stage,
\code{params} a list of parameters for the simulation, \code{M0} a vector of initial conditions
}
\description{
This function calculates deterministic equilibria for the mosquito lifecycle
model.
}
\details{
Equilibrium can be calculated using one of two models: classic logistic dynamics
or following the Lotka-Volterra competition model. This is determined by the
parameter \code{log_dd}, and it changes elements of the return list: \code{K} is
returned for logistic dynamics, or \code{gamma} is returned for Lotka-Volterra
dynamics.

The places (\code{spn_P}) object is generated from one of the following:
\code{\link{spn_P_lifecycle_node}}, \code{\link{spn_P_lifecycle_network}},
\code{\link{spn_P_epiSIS_node}}, \code{\link{spn_P_epiSIS_network}},
\code{\link{spn_P_epiSEIR_node}}, or \code{\link{spn_P_epiSEIR_network}}.

The initial population genotype ratios are set by supplying the \code{pop_ratio_Aq},
\code{pop_ratio_F}, and \code{pop_ratio_M} values. The default value is NULL,
and the function will use the wild-type alleles provided in the \code{cube}
object. However, one can supply
several different objects to set the initial genotype ratios. All genotypes provided
must exist in the \code{cube} (this is checked by the function). If a single, named vector
is provided, then all patches will be initialized with the same ratios. If a
matrix is provided, with the number of columns (and column names) giving the
initial genotypes, and a row for each patch, each patch can be set to a different
initial ratio. The three parameters do not need to match each other.

The \code{params} argument supplies all of the ecological parameters necessary
to calculate equilibrium values. This is used to set the initial population
distribution and during the simulation to maintain equilibrium. \code{params}
must include the following named parameters:
\itemize{
\item \code{qE}: inverse of mean duration of egg stage
\item \code{nE}: shape parameter of Erlang-distributed egg stage
\item \code{qL}: inverse of mean duration of larval stage
\item \code{nL}: shape parameter of Erlang-distributed larval stage
\item \code{qP}: inverse of mean duration of pupal stage
\item \code{nP}: shape parameter of Erlang-distributed pupal stage
\item \code{muE}: egg mortality
\item \code{muL}: density-independent larvae mortality
\item \code{muP}: pupae mortality
\item \code{muF}: adult female mortality
\item \code{muM}: adult male mortality
\item \code{beta}: egg-laying rate, daily
\item \code{nu}: mating rate of unmated females
}

The return list contains all of the \code{params} parameters, along with the
density-dependent parameter, either \code{K} or \code{gamma}. These are the
parameters necessary later in the simulations. This was done for compatibility
with \code{\link{equilibrium_SEI_SIS}}, which requires several extra parameters
not required further in the simulations.

For equilibrium with epidemiological parameters, see \code{\link{equilibrium_SEI_SIS}}.
For equilibrium with latent humans (SEIR dynamics), see \code{\link{equilibrium_SEI_SEIR}}.
}
