KQM<-function(data,K,method,initial,iteration=1000,type=1,style=1) {

        InitialCenters.f<-function(data,InitialCMs,type) {
            C.L<-NULL
            for(i in 1:nrow(InitialCMs)){
                L<-vector()
                for(j in 1:nrow(data)) 
                     L[j]<-Dist(data[j,],InitialCMs[i,],type)            
                ind<-sort(L,index=TRUE)$ix
                for(t in 1:length(ind)) {
                     if(!is.element(ind[t],C.L)) {
                         C.L<-c(C.L,ind[t])
                         break
                     }
                }
            }           
            return(C.L)         # index pool of candidate initial centers 
        }
      
        DM.f<-function(data) {
            DM<-matrix(0,ncol=nrow(data),nrow=nrow(data))
            for(i in 1:nrow(data)) 
                for(j in i:nrow(data))
                   DM[i,j]<-Dist(data[i,],data[j,],type)
            DM1<-DM
            DM2<-t(DM1)
            DM<-DM1+DM2   
            colnames(DM)<-rownames(DM)<-1:nrow(data)     # distance matrix
            return(DM)
        }
        DM<-DM.f(data)

        Clustering<-function(data,DM,C,K) {
            CL<-vector()
            for(i in 1:nrow(data)) 
                CL[i]<-which(DM[i,C]==min(DM[i,C]))[1]

            C.new<-vector()
            for(i in 1:K) {
                Cl.ind<-which(CL==i)
                C.new[i]<-C.f(DM,Cl.ind)
            }

            p<-1
            while(!setequal(C,C.new)&p<iteration) {
                C<-C.new
                CL<-vector()
                for(i in 1:nrow(data))
                    CL[i]<-which(DM[i,C]==min(DM[i,C]))[1]

                C.new<-vector()
                for(i in 1:K) {
                    Cl.ind<-which(CL==i)
                    C.new[i]<-C.f(DM,Cl.ind)
                }
                p<-p+1
            }

            cl.ids<-list()
            clusters<-list()
            for(i in 1:K) {
                cl.ids[[i]]<-which(CL==i)
                clusters[[i]]<-data[cl.ids[[i]],]
            }

            SS<-NULL
            for(i in 1:K) {
                S<-sum(DM[C.new[i],cl.ids[[i]]])
                SS<-c(SS,S)
            }
            SS<-c(SS,sum(SS))
            Res.obj<-new("KQMobj",K=K,DM=DM,Centers.ix=C.new,Centers=data[C.new,],Classes=cl.ids,Clusters=clusters,SSE=SS)
            return(Res.obj)
        }

        if(method=="YY") {

            InitialCMs.f<-function(data=data,K=K) {
                Q<-NULL
                for(i in 1:ncol(data)) {
                    d<-(max(data[,i])-min(data[,i]))/(K+1)
                    m<-vector()
                    for(j in 1:K)
                        m[j]<-min(data[,i])+d*j
                    Q<-cbind(Q,m) 
                }
                colnames(Q)<-1:ncol(data)
                IND<-permutations(K,ncol(data),1:K,repeats.allowed=TRUE)  
                InitialCMs<-matrix(0,ncol=ncol(IND),nrow=nrow(IND))  
                for(i in 1:nrow(IND)) 
                    for(j in 1:ncol(IND))
                        InitialCMs[i,j]<-Q[,j][IND[i,j]]         # InitialCMs is pool of candidate initial centers
                InitialCMs
            }

            InitialCMs<-InitialCMs.f(data,K)
            p.C<-InitialCenters.f(data,InitialCMs,type=1)
            if(style==2) {
                dat<-data[p.C,] 
                C.m<-pam(dat,K)$medoids
                C<-InitialCenters.f(data,C.m,type=1)
                Res.obj<-Clustering(data,DM,C,K)
            }
            if(style==1) {
                f<-function() {
                    InitialCMs<-InitialCMs.f(data,K)
                    p.C<-InitialCenters.f(data,InitialCMs,type=1)
                    dat<-data[p.C,]
                    return(dat)
                }
                data.new<-f()  
                rownames(data.new)<-p.C
                DM.new<-DM.f(data.new) 
                colnames(DM.new)<-rownames(DM.new)<-p.C            
                InitialCMs.new<-InitialCMs.f(data.new,floor(K^(1/ncol(data))))
                less<-K-nrow(InitialCMs.new)
                M.less<-matrix(0,ncol=ncol(data),nrow=less)
                for(i in 1:ncol(data)) {
                    d<-(max(data[,i])-min(data[,i]))/(less+1)
                    m<-vector()
                    for(j in 1:less)
                        m[j]<-min(data[,i])+d*j
                    M.less[,i]<-m
                }
               
                InitialCMs<-rbind(InitialCMs.new,M.less)
                C<-InitialCenters.f(data,InitialCMs,type=1)
                Res.obj<-Clustering(data,DM,C,K)  
            }
        }

        if(method=="initial") {
            if(is.null(initial)) 
                 return("The initial cluster centers are missing!")
            if(is.matrix(initial)) {
                 if(nrow(initial)==K) C.m<-initial else {
                      print("Initial cluster centers are not qualified. The first K observations of the data set are automatically selected as initial cluster centers.")
                      cat("\n")
                      C.m<-data[1:K,]
                 }
            } else C.m<-data[1:K,]

            C<-InitialCenters.f(data,C.m,type=1)
            Res.obj<-Clustering(data,DM,C,K)                 
        }

        return(Res.obj)
}