% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaic_grid.R
\name{mosaic.grid}
\alias{mosaic.grid}
\title{Draws the density of a grid copula with mosaics}
\usage{
mosaic.grid(gc, number.size = 5)
}
\arguments{
\item{gc}{a grid type copula object.}

\item{number.size}{indicates the size of numbers.}
}
\value{
Returns a graph.
}
\description{
Draws the density of a grid copula with mosaics
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 10
m <- 10
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
mosaic.grid(gc = copula.grid, number.size = 5)

#Iris
copula.grid <- estimate.gridCopula(X = iris[,1:2], k = k, m = m , method = "ml")
mosaic.grid(gc = copula.grid, number.size = 5)
}
