% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPrep.R
\name{dataPrep}
\alias{dataPrep}
\title{Prepare copy number data for downstream analysis}
\usage{
dataPrep(
  X,
  Y = NULL,
  species = c("human", "mouse"),
  ensemblHost = "https://aug2020.archive.ensembl.org"
)
}
\arguments{
\item{X}{a matrix or a data frame of copy number data. The rows and columns
of X correspond to genes and subjects, respectively. X must have gene
symbols as its row names.}

\item{Y}{an optional matrix or data frame of copy number data to compare with
X. As is the case for X, the rows and columns of Y correspond to genes and
subjects, respectively. Y must have gene symbols as its row names.}

\item{species}{a value specifying species for ensembl database to be used;
Default is "human".}

\item{ensemblHost}{specifies the Ensembl archive used;
Default is "http://aug2020.archive.ensembl.org".}
}
\value{
a list of processed X and Y with a data frame containing gene
annotation information.
}
\description{
Prepare copy number data for downstream analysis
}
\details{
This helper function is designed to prepare input matrices or data frames
X and Y containing DNA copy number data for analysis. The downstream functions
that X and Y are indexed by a common set of genes that appear in genomic order.
In addition, the peelingOne and peelingTwo functions require information about
the cytoband for each gene, and the resultsProcess function uses information
about gene position. The dataPrep function queries biomaRt so users are not
required to provide this information.
}
\examples{
\donttest{
#This runtime for this code slightly exceeds the limits imposed by CRAN.
data(DiNAMIC.Duo)
output = dataPrep(X=luadSubset,Y=NULL)
}

}
