% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{DLData}
\alias{DLData}
\title{Create \code{DLData} object}
\usage{
DLData(
  sequences,
  weights = NULL,
  symbols = alphabet.dna$alphabet,
  colors = alphabet.dna$colors,
  delim = "",
  sortByWeights = !is.null(weights),
  axis.labels = NULL
)
}
\arguments{
\item{sequences}{the input sequences, may be provided as i) \code{character}
vector or ii) a \code{data.frame} with sequences organized in rows and one 
symbol per column}

\item{weights}{weights associated with the sequences, numeric vector of the 
same length as \code{sequences} has sequences}

\item{symbols}{the symbols (alphabet) over which the sequences are defined}

\item{colors}{colors for each of the \code{symbols}, not necessarily unique}

\item{delim}{delimiter between the symbols in the input sequences, ignored if
\code{sequences} as a \code{data.frame}}

\item{sortByWeights}{if \code{TRUE}, \code{sequences} will be ordered by 
their \code{weight} in decreasing order}

\item{axis.labels}{the labels of the individual sequence positions; 
if \code{NULL}, indexes from 1 to to total number of positions will be used}
}
\value{
the \code{DLData} object
}
\description{
Creates a new \code{DLData} object from a set of input sequences.
}
\details{
Sequences may either be provided as a \code{character} vector or as a
\code{data.frame}. All symbols occurring in these sequences need to be
defined and assigned to colors, which are used for plotting later. Colors do
not need to be unique, but symbols with identical colors may become
indistinguishable in subsequent plots (which might even be desired, for
instance, when visualizing protein properties instead of amino acids). 
Sequences may have an associated weight, which is used to order sequences,
e.g., for creating chunks/blocks of sequences in subsequent plots (see
\code{chunks} parameter of \code{plotDeplogo}).
}
\examples{
# creating a DLData object using default (DNA) alphabet and colors
# from a character vector with two entries
data <- DLData(c("ACGT", "ATTA"))

# creating a DLData object using a custom, binary alphabet and custom colors
data2 <- DLData(c("A,B,B,A,B", "A,B,B,A,A", "A,B,A,A,B"),
    symbols = c("A", "B"), colors = c("red","green"), delim = ",")

# creating a DLData object from a data frame 
# (created from a character vector, in this case)
vec <- c("A,B,B,A,B", "A,B,B,A,A", "A,B,A,A,B")
df <- as.data.frame(t(sapply(vec, function(a){strsplit(a, ",")[[1]]})))
data.df <- DLData(df, symbols = c("A", "B"), colors = c("red", "green"))

# creating a DLData object from sequences and weights, read from a tabular file
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"), 
    stringsAsFactors = FALSE)
data3 <- DLData(sequences = seqs[, 1], weights = log1p(seqs[, 2]) )
}
\seealso{
\link{plotDeplogo}
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
