% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_est.R
\name{to_pacf}
\alias{to_pacf}
\title{Computes the Standard Estimator of the Autocovariance Function.}
\usage{
to_pacf(estCov)
}
\arguments{
\item{estCov}{A numeric vector representing an estimated autocovariance or autocorrelation function.}
}
\value{
A vector whose values are an estimate partial autocorrelation function.
}
\description{
This function computes the partial autocorrelation function from an estimated autocovariance or autocorrelation function.
}
\details{
This function is a translation of the 'uni_pacf' function in src/library/stats/src/pacf.c of the R source code which is an implementation of the Durbin–Levinson algorithm.
}
\examples{
X <- c(1, 2, 3)
to_pacf(standard_est(X, pd = FALSE, maxLag = 2, meanX = mean(X)))
}
