% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B_splines_est.R
\name{adjusted_spline}
\alias{adjusted_spline}
\title{Compute Adjusted Splines.}
\usage{
adjusted_spline(x, j, l, p, m, taus)
}
\arguments{
\item{x}{Argument of the function.}

\item{j}{Index of basis function of order \eqn{l}.}

\item{l}{Order of function.}

\item{p}{The order of the splines.}

\item{m}{The number of nonboundary knots.}

\item{taus}{Vector of \eqn{\tau}s, see \link{get_tau}.}
}
\value{
A numeric value of the adjusted spline \eqn{f_{j}^{(l)}(x).}
}
\description{
A helper function that is an implementation of the formula from Choi, Li & Wang (2013, p. 616),
\deqn{
f_{j}^{(l)}(x) = \frac{m + 1}{l} \left( f_{j}^{(l - 1)}(x + 1) - \tau_{j - p} f_{j}^{(l - 1)}(x) + \tau_{j - p + l + 1} f_{j + 1}^{(l - 1)}(x) -  f_{j + 1}^{(l - 1)}(x + 1)  \right) ,
}
where \eqn{m} is the number of nonboundary knots, \eqn{p} is the order of the spline, \eqn{l} is the order of the adjusted spline (the function \eqn{f_{j}^{(l)}(\cdot)}) and \eqn{j = 1, 2, \dots , m + p.}
}
\examples{
taus <- get_taus(3, 2)
adjusted_spline(1, 2, 1, 3, 2, taus)
}
\references{
Choi, I., Li, B. & Wang, X. (2013). Nonparametric Estimation of Spatial and Space-Time Covariance Function. JABES 18, 611-630. https://doi.org/10.1007/s13253-013-0152-z
}
