% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_TRHbivariate.R
\name{graph_TRHbivariate}
\alias{graph_TRHbivariate}
\title{Graph a bivariate plot of temperature and humidity data}
\usage{
graph_TRHbivariate(
  mydata,
  Temp = "Temp",
  RH = "RH",
  z_func = "none",
  facet_by = "Sensor",
  LowT = 16,
  HighT = 25,
  LowRH = 40,
  HighRH = 60,
  Temp_range = c(0, 40),
  RH_range = c(0, 100),
  alpha = 0.5,
  limit_caption = ""
)
}
\arguments{
\item{mydata}{A data frame containing temperature (Temp) and relative humidity (RH) columns.}

\item{Temp}{The name of the column in mydata containing temperature data ("Temp").}

\item{RH}{The name of the column in mydata containing relative humidity data ("RH").}

\item{z_func}{A character string specifying which environmental metric function to use. See details for options (default `none`).}

\item{facet_by}{Name of categorical column to facet by; defaults to "Sensor".}

\item{LowT}{Numeric value for lower temperature limit of the target range. Default is 16°C.}

\item{HighT}{Numeric value for upper temperature limit of the target range. Default is 25°C.}

\item{LowRH}{Numeric value for lower relative humidity limit of the target range. Default is 40\%.}

\item{HighRH}{Numeric value for upper relative humidity limit of the target range. Default is 60\%.}

\item{Temp_range}{Numeric vector of length two defining x-axis plot limits for temperature.}

\item{RH_range}{Numeric vector of length two defining y-axis plot limits for relative humidity.}

\item{alpha}{Numeric transparency level for points.}

\item{limit_caption}{Character string caption describing plot limits.}
}
\value{
A ggplot2 plot object showing temperature vs relative humidity colored by the selected metric,
with annotated boundary segments.
}
\description{
Plots temperature vs relative humidity points coloured by a selected environmental metric
calculated from temperature and humidity variables using ConSciR functions.
}
\details{
Humidity and conservation functions can be used for the y-axis.

\itemize{
   \item calcHR: Humidity Ratio (g/kg)
   \item calcMR: Mixing Ratio (g/kg)
   \item calcAH: Absolute Humidity (g/m^3)
   \item calcSH: Specific Humidity (g/kg)
   \item calcAD: Air Density (kg/m^3)
   \item calcDP: Dew Point (°C)
   \item calcFP: Frost Point (°C)
   \item calcEnthalpy: Enthalpy (kJ/kg)
   \item calcPws: Saturation vapor pressure (hPa)
   \item calcPw: Water Vapour Pressure (hPa)
   \item calcPI: Preservation Index
   \item calcLM: Lifetime
   \item calcEMC_wood: Equilibrium Moisture Content (wood)
}
}
\examples{

# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 100)

graph_TRHbivariate(
  mydata,
  z_func = "calcAH",
  LowT = 16, HighT = 25,
  LowRH = 40, HighRH = 60,
  Temp_range = c(0, 40),
  RH_range = c(0, 100),
  alpha = 0.7,
  limit_caption = "Example limit box"
)

}
