% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Bees_data}
\alias{Bees_data}
\title{Bee Occurrence Records}
\format{
A tibble with 105 observations and 124 variables:
\describe{
  \item{database_id}{Unique database identifier (character)}
  \item{scientificName}{Full scientific name (character)}
  \item{family}{Taxonomic family (character)}
  \item{subfamily}{Taxonomic subfamily (character)}
  \item{genus}{Taxonomic genus (character)}
  \item{subgenus}{Taxonomic subgenus (character)}
  \item{subspecies}{Taxonomic subspecies (character)}
  \item{species}{Species name (character)}
  \item{specificEpithet}{Specific epithet (character)}
  \item{infraspecificEpithet}{Infraspecific epithet (character)}
  \item{acceptedNameUsage}{Accepted taxonomic name (character)}
  \item{taxonRank}{Rank of the taxon (character)}
  \item{scientificNameAuthorship}{Authority for the name (character)}
  \item{decimalLatitude}{Geographic latitude (numeric)}
  \item{decimalLongitude}{Geographic longitude (numeric)}
  \item{stateProvince}{Administrative region (character)}
  \item{continent}{Continent name (character)}
  \item{locality}{Locality description (character)}
  \item{eventDate}{Date of collection event (date/character)}
  \item{year}{Year of collection (integer)}
  \item{basisOfRecord}{Type of record (e.g., specimen, observation) (character)}
  \item{occurrenceStatus}{Occurrence status (character)}
  \item{recordedBy}{Collector(s) name(s) (character)}
  \item{institutionCode}{Code of institution holding the record (character)}
  \item{datasetName}{Name of the source dataset (character)}
  \item{gbifID}{Global Biodiversity Information Facility record ID (character)}
  \item{spatiallyValid}{Spatial validity flag (logical)}
  \item{coordinateUncertaintyInMeters}{Uncertainty of coordinates (numeric)}
  \item{hasGeospatialIssues}{Flag for geospatial issues (logical)}
  \item{duplicateStatus}{Duplicate record flag (character)}
  \item{.GBIFflags}{GBIF quality control flags (character)}
  \item{...}{Additional metadata on taxonomy, collection, and validation flags (90+ fields)}
}
}
\source{
Extracted from the **BeeBDC** package, version 1.3.0.
}
\usage{
data(Bees_data)
}
\description{
The `Bees_data` dataset contains occurrence records of bee species,
including detailed taxonomy, geographic coordinates, collection metadata,
and data quality flags. It is designed for biodiversity, ecology,
and conservation studies involving bee populations.
}
\details{
This dataset is rich in metadata and includes validation flags such as:
\itemize{
  \item Coordinate validity and uncertainty
  \item Taxonomic cleaning and synonym resolution
  \item Record duplication and licensing status
  \item Event and occurrence metadata
}
}
