% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{kusto_database_endpoint}
\alias{kusto_database_endpoint}
\title{Endpoints for communicating with a Kusto database}
\usage{
kusto_database_endpoint(
  ...,
  .connection_string = NULL,
  .query_token = NULL,
  .use_integer64 = FALSE
)
}
\arguments{
\item{...}{Named arguments which are the properties for the endpoint object. See 'Details' below for the properties that AzureKusto recognises.}

\item{.connection_string}{An alternative way of specifying the properties, as a database connection string. Properties supplied here override those in \code{...} if they overlap.}

\item{.query_token}{Optionally, an Azure Active Directory (AAD) token to authenticate with. If this is supplied, it overrides other tokens specified in \code{...} or in the connection string.}

\item{.use_integer64}{For \code{kusto_database_endpoint}, whether to convert columns with Kusto \code{long} datatype into 64-bit integers in R, using the bit64 package. If FALSE, represent them as numeric instead.}
}
\value{
An object of class \code{kusto_database_endpoint}.
}
\description{
Endpoints for communicating with a Kusto database
}
\details{
This is a list of properties recognised by \code{kusto_database_endpoint}, and their alternate names. Property names not in this list will generate an error. Note that not all properties that are recognised are currently supported by AzureKusto.

General properties:
\itemize{
\item server: The URI of the server, usually of the form 'https://clustername.location.kusto.windows.net'.
\itemize{
\item addr, address, network address, datasource, host
}
\item database: The database.
\itemize{
\item initialcatalog, dbname
}
\item tenantid: The AAD tenant name or ID to authenticate with.
\itemize{
\item authority
}
\item appclientid: The AAD app/service principal ID
\itemize{
\item applicationclientid
}
\item traceclientversion: The client version for tracing.
\item queryconsistency: The level of query consistency. Defaults to "weakconsistency".
\item response_dynamic_serialization: How to serialize dynamic responses.
\item response_dynamic_serialization_2: How to serialize dynamic responses.
}

User authentication properties:
\itemize{
\item password
}
\itemize{
\item user: The user name.
\itemize{
\item uid, userid
}
\item traceusername: The user name for tracing.
\item usertoken: The AAD token for user authentication.
\item 
\itemize{
\item usertoken, usrtoken
}
\item fed: Logical, whether federated authentication is enabled. Currently unsupported; if this is TRUE, \code{kusto_database_endpoint} will print a warning and ignore it.
\itemize{
\item federated security, federated, aadfed, aadfederatedsecurity
}
}

App authentication properties:
\itemize{
\item appkey: The secret key for the app.
\itemize{
\item applicationkey
}
\item traceappname: The AAD app for tracing.
\item apptoken: The AAD token for app authentication.
\itemize{
\item apptoken, applicationtoken
}
}

Currently, AzureKusto only supports authentication via Azure Active Directory. Authenticating with DSTS is planned for the future.

The way \code{kusto_database_endpoint} obtains an AAD token is as follows.
\enumerate{
\item If the \code{.query_token} argument is supplied, use it.
\item Otherwise, if the \code{usertoken} property is supplied, use it.
\item Otherwise, if the \code{apptoken} property is supplied, use it.
\item Otherwise, if the \code{appclientid} property is supplied, use it to obtain a token:
\itemize{
\item With the \code{user} and \code{pwd} properties if available
\item Or with the \code{appkey} property if available
\item Otherwise do an interactive authentication and ask for the user credentials
}
\item Otherwise, if no \code{appclientid} property is supplied, authenticate with the KustoClient app:
\itemize{
\item With the \code{user} and \code{pwd} properties if available
\item Otherwise do an interactive authentication and ask for the user credentials using a device code
}
}
}
\examples{
\dontrun{

kusto_database_endpoint(server="myclust.australiaeast.kusto.windows.net", database="db1")

# supplying a token obtained previously
token <- get_kusto_token("myclust.australiaeast.kusto.windows.net")
kusto_database_endpoint(server="myclust.australiaeast.kusto.windows.net", database="db1",
                        .query_token=token)

}
}
\seealso{
\link{run_query}, \link{az_kusto_database}
}
