/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.toolkit;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.rosuda.JGR.toolkit.PrefDialog;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.toolkit.DeducerPrefs;
import org.rosuda.ibase.Common;

public class PrefPanel
extends PrefDialog.PJPanel
implements ActionListener {
    private JPanel menuPanel;
    private JCheckBox data;
    private JCheckBox macChooser;
    private JPanel macPanel;
    private JCheckBox dataViewerStartUp;
    private JPanel dataViewerPanel;
    private JCheckBox analysis;

    public PrefPanel() {
        this.initGUI();
        this.reset();
        if (!Common.isMac()) {
            this.macChooser.setSelected(false);
            this.macChooser.setEnabled(false);
        }
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(560, 400));
            this.setLayout(null);
            this.menuPanel = new JPanel();
            this.menuPanel.setLayout(null);
            this.add(this.menuPanel);
            this.menuPanel.setBounds(118, 12, 305, 140);
            this.menuPanel.setBorder(BorderFactory.createTitledBorder("Console Menus"));
            this.data = new JCheckBox();
            this.menuPanel.add(this.data);
            this.data.setText("'Data' menu at start-up");
            this.data.setBounds(17, 41, 271, 19);
            this.analysis = new JCheckBox();
            this.menuPanel.add(this.analysis);
            this.analysis.setText("'Analysis' menu at start-up");
            this.analysis.setBounds(17, 72, 271, 19);
            this.dataViewerPanel = new JPanel();
            this.add(this.dataViewerPanel);
            this.dataViewerPanel.setBounds(118, 158, 305, 105);
            this.dataViewerPanel.setBorder(BorderFactory.createTitledBorder("Data Viewer"));
            this.dataViewerPanel.setLayout(null);
            this.dataViewerStartUp = new JCheckBox();
            this.dataViewerPanel.add(this.dataViewerStartUp);
            this.dataViewerStartUp.setText("Show Data Viewer on Start-up");
            this.dataViewerStartUp.setBounds(17, 43, 271, 19);
            this.macPanel = new JPanel();
            this.add(this.macPanel);
            this.macPanel.setBounds(118, 269, 305, 75);
            this.macPanel.setBorder(BorderFactory.createTitledBorder("Mac OS X"));
            this.macPanel.setLayout(null);
            this.macChooser = new JCheckBox();
            this.macPanel.add(this.macChooser);
            this.macChooser.setText("Native Look and Feel (quaqua)");
            this.macChooser.setBounds(17, 32, 283, 19);
            this.macPanel.setVisible(false);
            this.setName("Deducer");
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void saveAll() {
        DeducerPrefs.SHOWANALYSIS = this.analysis.isSelected();
        DeducerPrefs.SHOWDATA = this.data.isSelected();
        DeducerPrefs.VIEWERATSTARTUP = this.dataViewerStartUp.isSelected();
        DeducerPrefs.writePrefs();
    }

    public void reset() {
        this.analysis.setSelected(DeducerPrefs.SHOWANALYSIS);
        this.data.setSelected(DeducerPrefs.SHOWDATA);
        this.macChooser.setSelected(DeducerPrefs.USEQUAQUACHOOSER);
        this.dataViewerStartUp.setSelected(DeducerPrefs.VIEWERATSTARTUP);
    }

    public void resetToFactory() {
        this.analysis.setSelected(true);
        this.data.setSelected(true);
        this.macChooser.setSelected(Common.isMac());
        this.dataViewerStartUp.setSelected(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Save All") {
            this.saveAll();
        } else if (string == "Cancel") {
            this.reset();
        } else if (string == "Reset All") {
            this.resetToFactory();
        }
    }
}

