/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.strategy.selectors.variables.AbstractCriterionBasedVariableSelector;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.VariableUtils;

public class DomOverWDeg<V extends Variable>
extends AbstractCriterionBasedVariableSelector<V>
implements IMonitorRestart {
    public DomOverWDeg(V[] variables, long seed) {
        this((Variable[])variables, seed, Integer.MAX_VALUE);
    }

    public DomOverWDeg(V[] variables, long seed, int flushThs) {
        super(variables, seed, flushThs);
    }

    @Override
    public final boolean init() {
        if (!this.solver.getSearchMonitors().contains(this)) {
            this.solver.plugMonitor(this);
        }
        return true;
    }

    @Override
    public final void remove() {
        if (this.solver.getSearchMonitors().contains(this)) {
            this.solver.unplugMonitor(this);
        }
    }

    @Override
    protected final double weight(Variable v) {
        return 1.0 + this.weights.get(v);
    }

    @Override
    void increase(Propagator<?> prop, AbstractCriterionBasedVariableSelector.Element elt, double[] ws) {
        int dk;
        int s = prop.getModel().getEnvironment().getWorldIndex();
        int dj = prop.getVar(elt.ws[0]).instantiationWorldIndex();
        boolean futVar1 = Math.min(dj, dk = prop.getVar(elt.ws[1]).instantiationWorldIndex()) < s;
        for (int i = 0; i < prop.getNbVars(); ++i) {
            if (prop.getVar(i).isAConstant() || !VariableUtils.isInt(prop.getVar(i))) continue;
            IntVar ivar = (IntVar)prop.getVar(i);
            if (i == elt.ws[0] && futVar1) {
                this.environment.saveAt(() -> this.weights.adjustOrPutValue(ivar, 1.0, 1.0), dk);
            } else {
                this.weights.adjustOrPutValue(ivar, 1.0, 1.0);
            }
            int n = i;
            ws[n] = ws[n] + 1.0;
        }
    }

    @Override
    final int remapInc() {
        return 1;
    }

    @Override
    public void afterRestart() {
        if (this.flushWeights(this.weights)) {
            this.weights.forEachEntry((a1, b) -> {
                this.weights.put(a1, 0.0);
                return true;
            });
        }
    }
}

