/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.smsd.ring.HanserRingFinder;
import org.openscience.cdk.smsd.tools.BondEnergies;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

@Deprecated
public class ChemicalFilters {
    private List<Map<Integer, Integer>> allMCS;
    private Map<Integer, Integer> firstSolution;
    private List<Map<IAtom, IAtom>> allAtomMCS;
    private Map<IAtom, IAtom> firstAtomMCS;
    private List<Double> stereoScore;
    private List<Integer> fragmentSize;
    private List<Double> bEnergies;
    private IAtomContainer rMol;
    private IAtomContainer pMol;

    public ChemicalFilters(List<Map<Integer, Integer>> allMCS, List<Map<IAtom, IAtom>> allAtomMCS, Map<Integer, Integer> firstSolution, Map<IAtom, IAtom> firstAtomMCS, IAtomContainer sourceMol, IAtomContainer targetMol) {
        this.allAtomMCS = allAtomMCS;
        this.allMCS = allMCS;
        this.firstAtomMCS = firstAtomMCS;
        this.firstSolution = firstSolution;
        this.pMol = targetMol;
        this.rMol = sourceMol;
        this.stereoScore = new ArrayList<Double>();
        this.fragmentSize = new ArrayList<Integer>();
        this.bEnergies = new ArrayList<Double>();
    }

    private void clear() {
        this.firstSolution.clear();
        this.allMCS.clear();
        this.allAtomMCS.clear();
        this.firstAtomMCS.clear();
        this.stereoScore.clear();
        this.fragmentSize.clear();
        this.bEnergies.clear();
    }

    private void clear(Map<Integer, Map<Integer, Integer>> sortedAllMCS, Map<Integer, Map<IAtom, IAtom>> sortedAllAtomMCS, Map<Integer, Double> stereoScoreMap, Map<Integer, Integer> fragmentScoreMap, Map<Integer, Double> energySelectionMap) {
        sortedAllMCS.clear();
        sortedAllAtomMCS.clear();
        stereoScoreMap.clear();
        fragmentScoreMap.clear();
        energySelectionMap.clear();
    }

    private void addSolution(int counter, int key, Map<Integer, Map<IAtom, IAtom>> allFragmentAtomMCS, Map<Integer, Map<Integer, Integer>> allFragmentMCS, Map<Integer, Double> stereoScoreMap, Map<Integer, Double> energyScoreMap, Map<Integer, Integer> fragmentScoreMap) {
        this.allAtomMCS.add(counter, allFragmentAtomMCS.get(key));
        this.allMCS.add(counter, allFragmentMCS.get(key));
        this.stereoScore.add(counter, stereoScoreMap.get(key));
        this.fragmentSize.add(counter, fragmentScoreMap.get(key));
        this.bEnergies.add(counter, energyScoreMap.get(key));
    }

    private void initializeMaps(Map<Integer, Map<Integer, Integer>> sortedAllMCS, Map<Integer, Map<IAtom, IAtom>> sortedAllAtomMCS, Map<Integer, Double> stereoScoreMap, Map<Integer, Integer> fragmentScoreMap, Map<Integer, Double> energySelectionMap) {
        Integer n;
        Integer index = 0;
        for (Map<IAtom, IAtom> map : this.allAtomMCS) {
            sortedAllAtomMCS.put(index, map);
            fragmentScoreMap.put(index, 0);
            energySelectionMap.put(index, 0.0);
            stereoScoreMap.put(index, 0.0);
            n = index;
            index = index + 1;
        }
        index = 0;
        for (Map<Object, Object> map : this.allMCS) {
            sortedAllMCS.put(index, map);
            n = index;
            index = index + 1;
        }
        index = 0;
        for (Double d : this.bEnergies) {
            energySelectionMap.put(index, d);
            n = index;
            index = index + 1;
        }
        index = 0;
        for (Integer n2 : this.fragmentSize) {
            fragmentScoreMap.put(index, n2);
            n = index;
            index = index + 1;
        }
        index = 0;
        for (Double d : this.stereoScore) {
            stereoScoreMap.put(index, d);
            n = index;
            index = index + 1;
        }
    }

    public synchronized void sortResultsByStereoAndBondMatch() throws CDKException {
        HashMap<Integer, Map<Integer, Integer>> allStereoMCS = new HashMap<Integer, Map<Integer, Integer>>();
        HashMap<Integer, Map<IAtom, IAtom>> allStereoAtomMCS = new HashMap<Integer, Map<IAtom, IAtom>>();
        TreeMap<Integer, Integer> fragmentScoreMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Double> energyScoreMap = new TreeMap<Integer, Double>();
        Map<Integer, Double> stereoScoreMap = new HashMap<Integer, Double>();
        this.initializeMaps(allStereoMCS, allStereoAtomMCS, stereoScoreMap, fragmentScoreMap, energyScoreMap);
        boolean stereoMatchFlag = this.getStereoBondChargeMatch(stereoScoreMap, allStereoMCS, allStereoAtomMCS);
        boolean flag = false;
        if (stereoMatchFlag) {
            double higestStereoScore;
            double secondhigestStereoScore = higestStereoScore = (stereoScoreMap = ChemicalFilters.sortMapByValueInDecendingOrder(stereoScoreMap)).isEmpty() ? 0.0 : stereoScoreMap.values().iterator().next();
            for (Integer key : stereoScoreMap.keySet()) {
                if (secondhigestStereoScore < higestStereoScore && stereoScoreMap.get(key) > secondhigestStereoScore) {
                    secondhigestStereoScore = stereoScoreMap.get(key);
                    continue;
                }
                if (secondhigestStereoScore != higestStereoScore || !(stereoScoreMap.get(key) < secondhigestStereoScore)) continue;
                secondhigestStereoScore = stereoScoreMap.get(key);
            }
            if (!stereoScoreMap.isEmpty()) {
                flag = true;
                this.clear();
            }
            int counter = 0;
            for (Integer i : stereoScoreMap.keySet()) {
                if (higestStereoScore != stereoScoreMap.get(i)) continue;
                this.addSolution(counter, i, allStereoAtomMCS, allStereoMCS, stereoScoreMap, energyScoreMap, fragmentScoreMap);
                ++counter;
            }
            if (flag) {
                this.firstSolution.putAll(this.allMCS.get(0));
                this.firstAtomMCS.putAll(this.allAtomMCS.get(0));
                this.clear(allStereoMCS, allStereoAtomMCS, stereoScoreMap, fragmentScoreMap, energyScoreMap);
            }
        }
    }

    public synchronized void sortResultsByFragments() {
        TreeMap<Integer, Map<Integer, Integer>> allFragmentMCS = new TreeMap<Integer, Map<Integer, Integer>>();
        TreeMap<Integer, Map<IAtom, IAtom>> allFragmentAtomMCS = new TreeMap<Integer, Map<IAtom, IAtom>>();
        TreeMap<Integer, Double> stereoScoreMap = new TreeMap<Integer, Double>();
        TreeMap<Integer, Double> energyScoreMap = new TreeMap<Integer, Double>();
        TreeMap<Integer, Integer> fragmentScoreMap = new TreeMap<Integer, Integer>();
        this.initializeMaps(allFragmentMCS, allFragmentAtomMCS, stereoScoreMap, fragmentScoreMap, energyScoreMap);
        int minFragmentScore = 9999;
        for (Integer key : allFragmentAtomMCS.keySet()) {
            Map mcsAtom = (Map)allFragmentAtomMCS.get(key);
            int fragmentCount = this.getMappedMoleculeFragmentSize(mcsAtom);
            fragmentScoreMap.put(key, fragmentCount);
            if (minFragmentScore <= fragmentCount) continue;
            minFragmentScore = fragmentCount;
        }
        boolean flag = false;
        if (minFragmentScore < 9999) {
            flag = true;
            this.clear();
        }
        int counter = 0;
        for (Map.Entry map : fragmentScoreMap.entrySet()) {
            if (minFragmentScore != (Integer)map.getValue()) continue;
            this.addSolution(counter, (Integer)map.getKey(), allFragmentAtomMCS, allFragmentMCS, stereoScoreMap, energyScoreMap, fragmentScoreMap);
            ++counter;
        }
        if (flag) {
            this.firstSolution.putAll(this.allMCS.get(0));
            this.firstAtomMCS.putAll(this.allAtomMCS.get(0));
            this.clear(allFragmentMCS, allFragmentAtomMCS, stereoScoreMap, fragmentScoreMap, energyScoreMap);
        }
    }

    public synchronized void sortResultsByEnergies() throws CDKException {
        TreeMap<Integer, Map<Integer, Integer>> allEnergyMCS = new TreeMap<Integer, Map<Integer, Integer>>();
        TreeMap<Integer, Map<IAtom, IAtom>> allEnergyAtomMCS = new TreeMap<Integer, Map<IAtom, IAtom>>();
        TreeMap<Integer, Double> stereoScoreMap = new TreeMap<Integer, Double>();
        TreeMap<Integer, Integer> fragmentScoreMap = new TreeMap<Integer, Integer>();
        Map<Integer, Double> energySelectionMap = new TreeMap<Integer, Double>();
        this.initializeMaps(allEnergyMCS, allEnergyAtomMCS, stereoScoreMap, fragmentScoreMap, energySelectionMap);
        for (Integer key : allEnergyMCS.keySet()) {
            Map mcsAtom = (Map)allEnergyMCS.get(key);
            Double energies = this.getMappedMoleculeEnergies(mcsAtom);
            energySelectionMap.put(key, energies);
        }
        energySelectionMap = ChemicalFilters.sortMapByValueInAccendingOrder(energySelectionMap);
        boolean flag = false;
        double lowestEnergyScore = 9.999999999E7;
        if (energySelectionMap.size() > 0) {
            Integer key = energySelectionMap.keySet().iterator().next();
            lowestEnergyScore = energySelectionMap.get(key);
            flag = true;
            this.clear();
        }
        int counter = 0;
        for (Map.Entry<Integer, Double> map : energySelectionMap.entrySet()) {
            if (lowestEnergyScore != map.getValue()) continue;
            this.addSolution(counter, map.getKey(), allEnergyAtomMCS, allEnergyMCS, stereoScoreMap, energySelectionMap, fragmentScoreMap);
            ++counter;
        }
        if (flag) {
            this.firstSolution.putAll(this.allMCS.get(0));
            this.firstAtomMCS.putAll(this.allAtomMCS.get(0));
            this.clear(allEnergyMCS, allEnergyAtomMCS, stereoScoreMap, fragmentScoreMap, energySelectionMap);
        }
    }

    private Map<IBond, IBond> makeBondMapsOfAtomMaps(IAtomContainer ac1, IAtomContainer ac2, Map<Integer, Integer> mappings) {
        HashMap<IBond, IBond> maps = new HashMap<IBond, IBond>();
        for (IAtom atoms : ac1.atoms()) {
            int ac1AtomNumber = ac1.indexOf(atoms);
            if (!mappings.containsKey(ac1AtomNumber)) continue;
            int ac2AtomNumber = mappings.get(ac1AtomNumber);
            List connectedAtoms = ac1.getConnectedAtomsList(atoms);
            for (IAtom cAtoms : connectedAtoms) {
                int ac1ConnectedAtomNumber = ac1.indexOf(cAtoms);
                if (!mappings.containsKey(ac1ConnectedAtomNumber)) continue;
                int ac2ConnectedAtomNumber = mappings.get(ac1ConnectedAtomNumber);
                IBond ac1Bond = ac1.getBond(atoms, cAtoms);
                IBond ac2Bond = ac2.getBond(ac2.getAtom(ac2AtomNumber), ac2.getAtom(ac2ConnectedAtomNumber));
                if (ac2Bond == null) {
                    ac2Bond = ac2.getBond(ac2.getAtom(ac2ConnectedAtomNumber), ac2.getAtom(ac2AtomNumber));
                }
                if (ac1Bond == null || ac2Bond == null) continue;
                maps.put(ac1Bond, ac2Bond);
            }
        }
        return maps;
    }

    private synchronized int getMappedMoleculeFragmentSize(Map<IAtom, IAtom> mcsAtomSolution) {
        IAtomContainer educt = (IAtomContainer)DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, new Object[]{this.rMol});
        IAtomContainer product = (IAtomContainer)DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, new Object[]{this.pMol});
        if (mcsAtomSolution != null) {
            for (Map.Entry<IAtom, IAtom> map : mcsAtomSolution.entrySet()) {
                IAtom atomE = map.getKey();
                IAtom atomP = map.getValue();
                educt.removeAtom(atomE);
                product.removeAtom(atomP);
            }
        }
        return this.getfragmentCount(educt) + this.getfragmentCount(product);
    }

    private synchronized Double getMappedMoleculeEnergies(Map<Integer, Integer> mcsAtomSolution) throws CDKException {
        double totalBondEnergy = -9999.0;
        IAtomContainer educt = (IAtomContainer)DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, new Object[]{this.rMol});
        IAtomContainer product = (IAtomContainer)DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, new Object[]{this.pMol});
        for (IAtom iAtom : educt.atoms()) {
            iAtom.setFlag(1, false);
        }
        for (IAtom iAtom : product.atoms()) {
            iAtom.setFlag(1, false);
        }
        if (mcsAtomSolution != null) {
            for (Map.Entry entry : mcsAtomSolution.entrySet()) {
                int eNum = (Integer)entry.getKey();
                int pNum = (Integer)entry.getValue();
                IAtom eAtom = educt.getAtom(eNum);
                IAtom pAtom = product.getAtom(pNum);
                eAtom.setFlag(1, true);
                pAtom.setFlag(1, true);
            }
        }
        if (mcsAtomSolution != null) {
            totalBondEnergy = this.getEnergy(educt, product);
        }
        return totalBondEnergy;
    }

    static Map<Integer, Double> sortMapByValueInAccendingOrder(Map<Integer, Double> map) {
        LinkedList<Map.Entry<Integer, Double>> list = new LinkedList<Map.Entry<Integer, Double>>(map.entrySet());
        list.sort(new Comparator<Map.Entry<Integer, Double>>(){

            @Override
            public int compare(Map.Entry<Integer, Double> entry, Map.Entry<Integer, Double> entry1) {
                return entry.getValue().equals(entry1.getValue()) ? 0 : (entry.getValue() > entry1.getValue() ? 1 : -1);
            }
        });
        LinkedHashMap<Integer, Double> result = new LinkedHashMap<Integer, Double>();
        for (Map.Entry entry : list) {
            result.put((Integer)entry.getKey(), (Double)entry.getValue());
        }
        return result;
    }

    static Map<Integer, Double> sortMapByValueInDecendingOrder(Map<Integer, Double> map) {
        LinkedList<Map.Entry<Integer, Double>> list = new LinkedList<Map.Entry<Integer, Double>>(map.entrySet());
        list.sort(new Comparator<Map.Entry<Integer, Double>>(){

            @Override
            public int compare(Map.Entry<Integer, Double> entry, Map.Entry<Integer, Double> entry1) {
                return entry.getValue().equals(entry1.getValue()) ? 0 : (entry.getValue() < entry1.getValue() ? 1 : -1);
            }
        });
        LinkedHashMap<Integer, Double> result = new LinkedHashMap<Integer, Double>();
        for (Map.Entry entry : list) {
            result.put((Integer)entry.getKey(), (Double)entry.getValue());
        }
        return result;
    }

    public List<Double> getSortedEnergy() {
        return Collections.unmodifiableList(this.bEnergies);
    }

    public List<Integer> getSortedFragment() {
        return Collections.unmodifiableList(this.fragmentSize);
    }

    public List<Double> getStereoMatches() {
        return Collections.unmodifiableList(this.stereoScore);
    }

    private List<Object> getMappedFragment(IAtomContainer molecule, Collection<IAtom> atomsMCS) throws CloneNotSupportedException {
        IAtomContainer subgraphContainer = (IAtomContainer)molecule.getBuilder().newInstance(IAtomContainer.class, new Object[]{molecule});
        ArrayList<IAtom> list = new ArrayList<IAtom>(atomsMCS.size());
        for (IAtom iAtom : atomsMCS) {
            int post = molecule.indexOf(iAtom);
            list.add(subgraphContainer.getAtom(post));
        }
        ArrayList<IAtom> rlist = new ArrayList<IAtom>();
        for (IAtom atoms : subgraphContainer.atoms()) {
            if (list.contains(atoms)) continue;
            rlist.add(atoms);
        }
        for (IAtom atoms : rlist) {
            subgraphContainer.removeAtom(atoms);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(list);
        arrayList.add(subgraphContainer);
        return arrayList;
    }

    private double getAtomScore(double score, Map<IAtom, IAtom> atomMapMCS, IAtomContainer reactant, IAtomContainer product) {
        for (Map.Entry<IAtom, IAtom> mappings : atomMapMCS.entrySet()) {
            IAtom rAtom = mappings.getKey();
            IAtom pAtom = mappings.getValue();
            int rHCount = 0;
            int pHCount = 0;
            double rBO = reactant.getBondOrderSum(rAtom);
            double pBO = product.getBondOrderSum(pAtom);
            if (rAtom.getImplicitHydrogenCount() != null) {
                rHCount = rAtom.getImplicitHydrogenCount();
            }
            if (pAtom.getImplicitHydrogenCount() != null) {
                pHCount = pAtom.getImplicitHydrogenCount();
            }
            int hScore = Math.abs(rHCount - pHCount);
            double boScore = Math.abs(rBO - pBO);
            score = rHCount != pHCount ? (score -= (double)hScore) : (score += (double)hScore);
            if (rBO != pBO) {
                score -= boScore;
                continue;
            }
            score += boScore;
        }
        return score;
    }

    private double getBondScore(double score, Map<IBond, IBond> bondMaps) {
        for (Map.Entry<IBond, IBond> matchedBonds : bondMaps.entrySet()) {
            IBond rBond = matchedBonds.getKey();
            IBond pBond = matchedBonds.getValue();
            score += this.getBondFormalChargeMatches(rBond, pBond);
            score += this.getBondTypeMatches(rBond, pBond);
        }
        return score;
    }

    private double getBondFormalChargeMatches(IBond rBond, IBond pBond) {
        double score = 0.0;
        if (rBond != null && pBond != null) {
            IAtom ratom1 = rBond.getBegin();
            IAtom ratom2 = rBond.getEnd();
            IAtom patom1 = pBond.getBegin();
            IAtom patom2 = pBond.getEnd();
            if (ratom1.getAtomicNumber().equals(patom1.getAtomicNumber()) && ratom2.getAtomicNumber().equals(patom2.getAtomicNumber())) {
                if (!(Objects.equals(ratom1.getFormalCharge(), patom1.getFormalCharge()) && Objects.equals(ratom2.getFormalCharge(), patom2.getFormalCharge()) || ChemicalFilters.convertBondOrder(rBond) == ChemicalFilters.convertBondOrder(pBond))) {
                    score += (double)(5 * Math.abs(ChemicalFilters.convertBondOrder(rBond) + ChemicalFilters.convertBondOrder(pBond)));
                }
                if (Objects.equals(ratom1.getFormalCharge(), patom1.getFormalCharge()) && ChemicalFilters.convertBondOrder(rBond) - ChemicalFilters.convertBondOrder(pBond) == 0) {
                    score += 100.0;
                }
                if (Objects.equals(ratom2.getFormalCharge(), patom2.getFormalCharge()) && ChemicalFilters.convertBondOrder(rBond) - ChemicalFilters.convertBondOrder(pBond) == 0) {
                    score += 100.0;
                }
            } else if (ratom1.getAtomicNumber().equals(patom2.getAtomicNumber()) && ratom2.getAtomicNumber().equals(patom1.getAtomicNumber())) {
                if (!(Objects.equals(ratom1.getFormalCharge(), patom2.getFormalCharge()) && Objects.equals(ratom2.getFormalCharge(), patom1.getFormalCharge()) || ChemicalFilters.convertBondOrder(rBond) == ChemicalFilters.convertBondOrder(pBond))) {
                    score += (double)(5 * Math.abs(ChemicalFilters.convertBondOrder(rBond) + ChemicalFilters.convertBondOrder(pBond)));
                }
                if (Objects.equals(ratom1.getFormalCharge(), patom2.getFormalCharge()) && ChemicalFilters.convertBondOrder(rBond) - ChemicalFilters.convertBondOrder(pBond) == 0) {
                    score += 100.0;
                }
                if (Objects.equals(ratom2.getFormalCharge(), patom1.getFormalCharge()) && ChemicalFilters.convertBondOrder(rBond) - ChemicalFilters.convertBondOrder(pBond) == 0) {
                    score += 100.0;
                }
            }
        }
        return score;
    }

    private double getBondTypeMatches(IBond queryBond, IBond targetBond) {
        double score = 0.0;
        if (targetBond instanceof IQueryBond && queryBond instanceof IBond) {
            IQueryBond bond = (IQueryBond)targetBond;
            IQueryAtom atom1 = (IQueryAtom)targetBond.getBegin();
            IQueryAtom atom2 = (IQueryAtom)targetBond.getEnd();
            if (bond.matches(queryBond)) {
                if (atom1.matches(queryBond.getBegin()) && atom2.matches(queryBond.getEnd()) || atom1.matches(queryBond.getEnd()) && atom2.matches(queryBond.getBegin())) {
                    score += 4.0;
                }
            } else {
                score -= 4.0;
            }
        } else if (queryBond instanceof IQueryBond && targetBond instanceof IBond) {
            IQueryBond bond = (IQueryBond)queryBond;
            IQueryAtom atom1 = (IQueryAtom)queryBond.getBegin();
            IQueryAtom atom2 = (IQueryAtom)queryBond.getEnd();
            if (bond.matches(targetBond)) {
                if (atom1.matches(targetBond.getBegin()) && atom2.matches(targetBond.getEnd()) || atom1.matches(targetBond.getEnd()) && atom2.matches(targetBond.getBegin())) {
                    score += 4.0;
                }
            } else {
                score -= 4.0;
            }
        } else {
            int reactantBondType = ChemicalFilters.convertBondOrder(queryBond);
            int productBondType = ChemicalFilters.convertBondOrder(targetBond);
            int rStereo = ChemicalFilters.convertBondStereo(queryBond);
            int pStereo = ChemicalFilters.convertBondStereo(targetBond);
            if (queryBond.getFlag(32) == targetBond.getFlag(32) && reactantBondType == productBondType) {
                score += 8.0;
            } else if (queryBond.getFlag(32) && targetBond.getFlag(32)) {
                score += 4.0;
            }
            score = reactantBondType == productBondType ? (score += (double)productBondType) : (score -= (double)(4 * Math.abs(reactantBondType - productBondType)));
            if (rStereo != 4 || pStereo != 4 || rStereo != 3 || pStereo != 3) {
                score = rStereo == pStereo ? (score += 1.0) : (score -= 1.0);
            }
        }
        return score;
    }

    private double getRingMatchScore(List<Object> list) {
        List listMap = (List)list.get(0);
        IAtomContainer ac = (IAtomContainer)list.get(1);
        HanserRingFinder ringFinder = new HanserRingFinder();
        IRingSet rRings = null;
        try {
            rRings = ringFinder.getRingSet(ac);
        }
        catch (CDKException ex) {
            Logger.getLogger(ChemicalFilters.class.getName()).log(Level.SEVERE, null, ex);
            return 0.0;
        }
        RingSetManipulator.sort((IRingSet)rRings);
        double lScore = this.getRingMatch(rRings, listMap);
        return lScore;
    }

    private double getEnergy(IAtomContainer educt, IAtomContainer product) throws CDKException {
        Double eEnergy = 0.0;
        BondEnergies bondEnergy = BondEnergies.getInstance();
        for (int i = 0; i < educt.getBondCount(); ++i) {
            IBond bond = educt.getBond(i);
            eEnergy = eEnergy + this.getBondEnergy(bond, bondEnergy);
        }
        Double pEnergy = 0.0;
        for (int j = 0; j < product.getBondCount(); ++j) {
            IBond bond = product.getBond(j);
            pEnergy = pEnergy + this.getBondEnergy(bond, bondEnergy);
        }
        return eEnergy + pEnergy;
    }

    private double getBondEnergy(IBond bond, BondEnergies bondEnergy) {
        Integer val;
        double energy = 0.0;
        if ((bond.getBegin().getFlag(1) && !bond.getEnd().getFlag(1) || !bond.getBegin().getFlag(1) && bond.getEnd().getFlag(1)) && (val = Integer.valueOf(bondEnergy.getEnergies(bond.getBegin(), bond.getEnd(), bond.getOrder()))) != null) {
            energy = val.intValue();
        }
        return energy;
    }

    private double getRingMatch(IRingSet rings, List<IAtom> atoms) {
        double score = 0.0;
        for (IAtom a : atoms) {
            for (IAtomContainer ring : rings.atomContainers()) {
                if (!ring.contains(a)) continue;
                score += 10.0;
            }
        }
        return score;
    }

    private boolean getStereoBondChargeMatch(Map<Integer, Double> stereoScoreMap, Map<Integer, Map<Integer, Integer>> allStereoMCS, Map<Integer, Map<IAtom, IAtom>> allStereoAtomMCS) throws CDKException {
        boolean stereoMatchFlag = false;
        IAtomContainer reactant = this.rMol;
        IAtomContainer product = this.pMol;
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)reactant);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)product);
        Aromaticity.cdkLegacy().apply(reactant);
        Aromaticity.cdkLegacy().apply(product);
        for (Integer key : allStereoMCS.keySet()) {
            try {
                double score = 0.0;
                Map<Integer, Integer> atomsMCS = allStereoMCS.get(key);
                Map<IAtom, IAtom> atomMapMCS = allStereoAtomMCS.get(key);
                score = this.getAtomScore(score, atomMapMCS, reactant, product);
                Map<IBond, IBond> bondMaps = this.makeBondMapsOfAtomMaps(this.rMol, this.pMol, atomsMCS);
                if (this.rMol.getBondCount() > 1 && this.pMol.getBondCount() > 1) {
                    List<Object> subgraphRList = this.getMappedFragment(this.rMol, atomMapMCS.keySet());
                    double rscore = this.getRingMatchScore(subgraphRList);
                    List<Object> subgraphPList = this.getMappedFragment(this.pMol, atomMapMCS.values());
                    double pscore = this.getRingMatchScore(subgraphPList);
                    score = rscore + pscore;
                }
                score = this.getBondScore(score, bondMaps);
                if (!stereoMatchFlag) {
                    stereoMatchFlag = true;
                }
                stereoScoreMap.put(key, score);
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(ChemicalFilters.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stereoMatchFlag;
    }

    private int getfragmentCount(IAtomContainer molecule) {
        IAtomContainerSet fragmentMolSet = (IAtomContainerSet)DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainerSet.class, new Object[0]);
        int countFrag = 0;
        if (molecule.getAtomCount() > 0) {
            boolean fragmentFlag = ConnectivityChecker.isConnected((IAtomContainer)molecule);
            if (!fragmentFlag) {
                fragmentMolSet.add(ConnectivityChecker.partitionIntoMolecules((IAtomContainer)molecule));
            } else {
                fragmentMolSet.addAtomContainer(molecule);
            }
            countFrag = fragmentMolSet.getAtomContainerCount();
        }
        return countFrag;
    }

    public static IBond.Order convertOrder(double srcOrder) {
        if (srcOrder > 3.5) {
            return IBond.Order.QUADRUPLE;
        }
        if (srcOrder > 2.5) {
            return IBond.Order.TRIPLE;
        }
        if (srcOrder > 1.5) {
            return IBond.Order.DOUBLE;
        }
        if (srcOrder > 0.5) {
            return IBond.Order.SINGLE;
        }
        return null;
    }

    public static int convertBondOrder(IBond bond) {
        int value;
        switch (bond.getOrder()) {
            case QUADRUPLE: {
                value = 4;
                break;
            }
            case TRIPLE: {
                value = 3;
                break;
            }
            case DOUBLE: {
                value = 2;
                break;
            }
            case SINGLE: {
                value = 1;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    public static int convertBondStereo(IBond bond) {
        int value;
        switch (bond.getStereo()) {
            case UP: {
                value = 1;
                break;
            }
            case UP_INVERTED: {
                value = 1;
                break;
            }
            case DOWN: {
                value = 6;
                break;
            }
            case DOWN_INVERTED: {
                value = 6;
                break;
            }
            case UP_OR_DOWN: {
                value = 4;
                break;
            }
            case UP_OR_DOWN_INVERTED: {
                value = 4;
                break;
            }
            case E_OR_Z: {
                value = 3;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    public static IBond.Stereo convertStereo(int stereoValue) {
        IBond.Stereo stereo = IBond.Stereo.NONE;
        if (stereoValue == 1) {
            stereo = IBond.Stereo.UP;
        } else if (stereoValue == 6) {
            stereo = IBond.Stereo.DOWN;
        } else if (stereoValue == 0) {
            stereo = IBond.Stereo.NONE;
        } else if (stereoValue == 4) {
            stereo = IBond.Stereo.UP_OR_DOWN;
        } else if (stereoValue == 3) {
            stereo = IBond.Stereo.E_OR_Z;
        }
        return stereo;
    }
}

