/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.automata.fast_multicostregular.MultiCostRegular;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.automaton.FA.IAutomaton;
import choco.kernel.model.constraints.automaton.FA.ICostAutomaton;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.List;

public final class MultiCostRegularManager
extends IntConstraintManager {
    public SConstraint makeConstraint(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver && parameters instanceof Object[]) {
            IntDomainVar[] all = solver.getVar(variables);
            Object[] param = (Object[])parameters;
            if (param.length == 3 && param[2] instanceof int[][][]) {
                IntDomainVar[] z;
                IntDomainVar[] vs;
                boolean inverted;
                int nVars = (Integer)param[0];
                int nCounters = all.length - nVars;
                IAutomaton pi = (IAutomaton)param[1];
                int[][][] costs = (int[][][])param[2];
                boolean bl = nVars != nCounters ? costs.length == nCounters : (inverted = !all[0].hasEnumeratedDomain() && all[nVars].hasEnumeratedDomain());
                if (nVars == nCounters && (!all[0].hasEnumeratedDomain() || all[nVars].hasEnumeratedDomain())) {
                    for (int i = 0; !inverted && i < nVars; ++i) {
                        if (all[i].getSup() <= costs[i].length) continue;
                        inverted = true;
                    }
                }
                if (!inverted) {
                    vs = new IntDomainVar[nVars];
                    z = new IntDomainVar[nCounters];
                    System.arraycopy(all, 0, vs, 0, nVars);
                    System.arraycopy(all, nVars, z, 0, nCounters);
                } else {
                    nCounters = nVars;
                    nVars = costs.length;
                    vs = new IntDomainVar[nVars];
                    z = new IntDomainVar[nCounters];
                    System.arraycopy(all, 0, z, 0, nCounters);
                    System.arraycopy(all, nCounters, vs, 0, nVars);
                }
                if (vs.length != costs.length && z.length != costs[0][0].length) {
                    throw new ModelException("length of arrays are invalid");
                }
                if (param[2] instanceof int[][][]) {
                    int[][][] csts = (int[][][])param[2];
                    return new MultiCostRegular(vs, z, pi, csts, solver);
                }
                int[][][][] csts = (int[][][][])param[2];
                return new MultiCostRegular(vs, z, pi, csts, solver);
            }
            if (param.length == 2) {
                int nVars = (Integer)param[0];
                int nCounters = all.length - nVars;
                ICostAutomaton pi = (ICostAutomaton)param[1];
                IntDomainVar[] vs = new IntDomainVar[nVars];
                IntDomainVar[] z = new IntDomainVar[nCounters];
                System.arraycopy(all, 0, vs, 0, nVars);
                System.arraycopy(all, nVars, z, 0, nCounters);
                return new MultiCostRegular(vs, z, pi, solver);
            }
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }
}

